/* Copyright (c) 2019-2025 The Khronos Group Inc.
 * Copyright (c) 2019-2025 Valve Corporation
 * Copyright (c) 2019-2025 LunarG, Inc.
 * Modifications Copyright (C) 2022 RasterGrid Kft.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <cassert>

// There are many times we want to assert, but also it is highly important to not crash for release builds.
// This Macro also makes it more obvious if we are returning early because of a known situation or if we are just guarding against
// something wrong actually happening.
#define ASSERT_AND_RETURN(cond) \
    do {                        \
        if (!(cond)) {          \
            assert(false);      \
            return;             \
        }                       \
    } while (0)

#define ASSERT_AND_RETURN_SKIP(cond) \
    do {                             \
        if (!(cond)) {               \
            assert(false);           \
            return skip;             \
        }                            \
    } while (0)

#define ASSERT_AND_CONTINUE(cond) \
    if (!(cond)) {                \
        assert(false);            \
        continue;                 \
    }
