/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_ERRORIMPL_H
#define _SC_UTIL_ERRORIMPL_H

// sc
#include "Error.h"

namespace sc
{

/**
 * an implementation of \sa sc::Error
 */
class ErrorImpl : public Error
{
public:
  ErrorImpl( const ErrorImpl& );
  ErrorImpl( long code, const String& msg );
  ErrorImpl( long code, const String& msg, const Error* nested );

  // @{
  long getCode() const;
  String getMessage() const;
  String getMessages() const;
  const Error* getNested() const;
  // @}

private:
  long         _code;
  String       _msg;

  const Error* _nested;
};

} // namespace

#if 0
/** factory "methods" for Errors with file and line information */
#define createError(code,msg)         (new sc::Error(code,msg,__FILE__,__LINE__))
#define createErrorW(code,msg,nested) (new sc::Error(code,msg,nested,__FILE__,__LINE__))
#endif

#endif // _SC_UTIL_ERRORIMPL_H
