/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BOOKMARKPROPERTIES_H
#define _SC_BOOKMARKPROPERTIES_H

// sc
class Bookmark;
class ExternProvider;
class ExternButton;

// qt
#include <QtGui/QDialog>
class QLineEdit;
class QPushButton;
class QCheckBox;
class QComboBox;


class BookmarkProperties : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  BookmarkProperties( Bookmark*, ExternProvider* p, QWidget* parent = 0 );
  virtual ~BookmarkProperties();

  QString getName();
  QString getSource();
  bool getAutoUpdate();

public slots:
  void checkOk( const QString& text );

private slots:
  void selectExtern();

private:
  QPixmap getPixmap();
  QString getType();

private:
  QLineEdit*      _name;
  QComboBox*      _source;
  ExternButton*   _ex;

  QCheckBox*      _update;

  QPushButton*    _ok;
  QPushButton*    _ca;

  ExternProvider* _p;

  Bookmark*       _bookmark;
};

#endif // _SC_BOOKMARKPROPERTIES_H
