-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:49 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "compound_history"
--
CREATE TABLE "compound_history" (
-- Comments: 
-- history table of the "compound" table
--

  -- unique table key in the history table
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- chemical formula of the phase
  "formula" varchar(255) DEFAULT NULL,
  -- European Community number associated with the compound
  "ec_number" char(9) DEFAULT NULL,
  -- the Chemical Abstracts Service (CAS) Registry Number associated with the compound
  "cas_number" varchar(12) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:50 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "compound"
--
CREATE TABLE "compound" (
-- Comments: 
-- stores information about the compounds that make up the phases
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- chemical formula of the phase
  "formula" varchar(255) DEFAULT NULL,
  -- European Community number associated with the compound
  "ec_number" char(9) DEFAULT NULL,
  -- the Chemical Abstracts Service (CAS) Registry Number associated with the compound
  "cas_number" varchar(12) DEFAULT NULL,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "compound_uuid" ON "compound" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:51 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "epma_content_history"
--
CREATE TABLE "epma_content_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "mineral_id" int(11) NOT NULL,
  "component" varchar(10) DEFAULT NULL,
  "value" real(8,2) DEFAULT NULL,
  "su" real(8,2) DEFAULT NULL
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:51 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "epma_content"
--
CREATE TABLE "epma_content" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "mineral_id" int(11) NOT NULL,
  "component" varchar(10) DEFAULT NULL,
  "value" real(8,2) DEFAULT NULL,
  "su" real(8,2) DEFAULT NULL,
  FOREIGN KEY ("mineral_id") REFERENCES "epma_mineral"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "epma_content_mineral_id" ON "epma_content" ("mineral_id");

CREATE UNIQUE INDEX "epma_content_uuid" ON "epma_content" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:52 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "epma_mineral_history"
--
CREATE TABLE "epma_mineral_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "name" varchar(255) DEFAULT NULL,
  "formula_struct" varchar(255) DEFAULT NULL,
  "analysis_count" smallint(6),
  "magnesium_percentage" real(8,2) DEFAULT NULL,
  "formula_oxygen_count" tinyint(4),
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:53 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "epma_mineral"
--
CREATE TABLE "epma_mineral" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "name" varchar(255) DEFAULT NULL,
  "formula_struct" varchar(255) DEFAULT NULL,
  "analysis_count" smallint(6),
  "magnesium_percentage" real(8,2) DEFAULT NULL,
  "formula_oxygen_count" tinyint(4),
  FOREIGN KEY ("experiment_id") REFERENCES "experiment_epma"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "epma_mineral_sample_id" ON "epma_mineral" ("experiment_id");

CREATE UNIQUE INDEX "epma_mineral_uuid" ON "epma_mineral" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:53 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_epma_history"
--
CREATE TABLE "experiment_epma_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "analytical_conditions" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:54 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_epma"
--
CREATE TABLE "experiment_epma" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "analytical_conditions" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("sample_id") REFERENCES "sample"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "experiment_epma_sample_id" ON "experiment_epma" ("sample_id");

CREATE UNIQUE INDEX "experiment_epma_uuid" ON "experiment_epma" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:55 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_optical_history"
--
CREATE TABLE "experiment_optical_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "description" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:56 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_optical"
--
CREATE TABLE "experiment_optical" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "description" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("sample_id") REFERENCES "sample"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "experiment_optical_sample_id" ON "experiment_optical" ("sample_id");

CREATE UNIQUE INDEX "experiment_optical_uuid" ON "experiment_optical" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:56 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_sem_history"
--
CREATE TABLE "experiment_sem_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "analytical_conditions" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:57 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_sem"
--
CREATE TABLE "experiment_sem" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "analytical_conditions" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("sample_id") REFERENCES "sample"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "experiment_sem_sample_id" ON "experiment_sem" ("sample_id");

CREATE UNIQUE INDEX "experiment_sem_uuid" ON "experiment_sem" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:58 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_xrf_history"
--
CREATE TABLE "experiment_xrf_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "analytical_conditions" varchar(255) DEFAULT NULL,
  "loi_content" real(8,2) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:25:58 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "experiment_xrf"
--
CREATE TABLE "experiment_xrf" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "sample_id" int(11) NOT NULL,
  "measurement_date" date DEFAULT NULL,
  "analytical_conditions" varchar(255) DEFAULT NULL,
  "loi_content" real(8,2) DEFAULT NULL,
  FOREIGN KEY ("sample_id") REFERENCES "sample"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "experiment_xrf_sample_id" ON "experiment_xrf" ("sample_id");

CREATE UNIQUE INDEX "experiment_xrf_uuid" ON "experiment_xrf" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:00 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "lithology_img_history"
--
CREATE TABLE "lithology_img_history" (
-- Comments: 
-- history table of the "lithology_img_history" table
--

  -- unique table key in the history table
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) NOT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- id of the related entry in the natural sample table
  "natural_sample_id" int(11) DEFAULT NULL,
  -- image caption
  "caption" varchar(255) DEFAULT NULL,
  -- binary image data
  "image" MEDIUMBLOB(16777215) DEFAULT NULL,
  -- data format of the stored image
  "format" enum(4) NOT NULL,
  -- image mimetype
  "mimetype" varchar(255) DEFAULT NULL,
  -- name of the CSS class that describes the way the image should be represented in (X)HTML
  "cssclass" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:01 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "lithology_img"
--
CREATE TABLE "lithology_img" (
-- Comments: 
-- stores images detailing the general physical characteristics of the sample
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) NOT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- id of the related entry in the natural sample table
  "natural_sample_id" int(11) DEFAULT NULL,
  -- image caption
  "caption" varchar(255) DEFAULT NULL,
  -- binary image data
  "image" MEDIUMBLOB(16777215) DEFAULT NULL,
  -- data format of the stored image
  "format" enum(4) NOT NULL,
  -- image mimetype
  "mimetype" varchar(255) DEFAULT NULL,
  -- name of the CSS class that describes the way the image should be represented in (X)HTML
  "cssclass" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("natural_sample_id") REFERENCES "natural_sample"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "lithology_img_uuid" ON "lithology_img" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:02 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "natural_sample_history"
--
CREATE TABLE "natural_sample_history" (
-- Comments: 
-- history table of the "natural_sample" table
--

  -- unique table key in the history table
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- unique table key
  "sample_id" int(11) NOT NULL,
  -- short description of the geological context
  "geo_context" varchar(255) DEFAULT NULL,
  -- id of the related entry in the origin table
  "origin_id" int(11) DEFAULT NULL,
  -- short description of the lithology
  "lithology" varchar(255) DEFAULT NULL,
  -- text describing the general physical characteristics of the sample
  "description" text DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:03 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "natural_sample"
--
CREATE TABLE "natural_sample" (
-- Comments: 
-- stores information related to the natural sample
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- unique table key
  "sample_id" int(11) NOT NULL,
  -- short description of the geological context
  "geo_context" varchar(255) DEFAULT NULL,
  -- id of the related entry in the origin table
  "origin_id" int(11) DEFAULT NULL,
  -- short description of the lithology
  "lithology" varchar(255) DEFAULT NULL,
  -- text describing the general physical characteristics of the sample
  "description" text DEFAULT NULL,
  FOREIGN KEY ("origin_id") REFERENCES "origin"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "natural_sample_uuid" ON "natural_sample" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:03 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "optical_img_history"
--
CREATE TABLE "optical_img_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "caption" varchar(255) DEFAULT NULL,
  "image" MEDIUMBLOB(16777215) DEFAULT NULL,
  "format" enum(4) NOT NULL,
  -- image mimetype
  "mimetype" varchar(255) DEFAULT NULL,
  -- name of the CSS class that describes the way the image should be represented in (X)HTML
  "cssclass" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:04 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "optical_img"
--
CREATE TABLE "optical_img" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "caption" varchar(255) DEFAULT NULL,
  "image" MEDIUMBLOB(16777215) DEFAULT NULL,
  "format" enum(4) NOT NULL,
  -- image mimetype
  "mimetype" varchar(255) DEFAULT NULL,
  -- name of the CSS class that describes the way the image should be represented in (X)HTML
  "cssclass" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("experiment_id") REFERENCES "experiment_optical"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "optical_img_uuid" ON "optical_img" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:05 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "origin_history"
--
CREATE TABLE "origin_history" (
-- Comments: 
-- history table of the "origin_history" table
--

  -- unique table key in the history table
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) NOT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- name of the general location where the sample was aquired
  "location" varchar(255) DEFAULT NULL,
  -- name of the mine where the sample was aquired
  "mine" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:05 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "origin"
--
CREATE TABLE "origin" (
-- Comments: 
-- stores information about the location the sample was aquired from
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) NOT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- name of the general location where the sample was aquired
  "location" varchar(255) DEFAULT NULL,
  -- name of the mine where the sample was aquired
  "mine" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "origin_uuid" ON "origin" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:06 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "phase_history"
--
CREATE TABLE "phase_history" (
-- Comments: 
-- stores information about the phases that make up the synthetic sample
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- id of the related entry in the synthetic sample table
  "synthetic_sample_id" int(11) DEFAULT NULL,
  -- id of the related entry in the compound table
  "compound_id" int(11) DEFAULT NULL,
  -- id of the related entry in the purchase table
  "purchase_id" int(11) DEFAULT NULL,
  -- the fraction of the phase in the sample expressed in percentage
  "percentage" real(8,2) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:06 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "phase"
--
CREATE TABLE "phase" (
-- Comments: 
-- stores information about the phases that make up the synthetic sample
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- id of the related entry in the synthetic sample table
  "synthetic_sample_id" int(11) DEFAULT NULL,
  -- id of the related entry in the compound table
  "compound_id" int(11) DEFAULT NULL,
  -- id of the related entry in the purchase table
  "purchase_id" int(11) DEFAULT NULL,
  -- the fraction of the phase in the sample expressed in percentage
  "percentage" real(8,2) DEFAULT NULL,
  FOREIGN KEY ("synthetic_sample_id") REFERENCES "synthetic_sample"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("compound_id") REFERENCES "compound"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("purchase_id") REFERENCES "purchase"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "phase_uuid" ON "phase" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:07 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "purchase_history"
--
CREATE TABLE "purchase_history" (
-- Comments: 
-- history table of the "purchase" table
--

  -- unique table key in the history table
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- name of the supplier
  "supplier" varchar(255) DEFAULT NULL,
  -- the unique identifier of the compound in the supplier's catalog
  "supplier_reference" varchar(255) DEFAULT NULL,
  -- the purity of the compound in percentage as stated by the supplier
  "purity" real(8,2) DEFAULT NULL,
  -- the batch of the compound
  "batch" varchar(255) DEFAULT NULL,
  -- the date of the purchase
  "date" date DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:08 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "purchase"
--
CREATE TABLE "purchase" (
-- Comments: 
-- stores information about the compound purchase
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- name of the supplier
  "supplier" varchar(255) DEFAULT NULL,
  -- the unique identifier of the compound in the supplier's catalog
  "supplier_reference" varchar(255) DEFAULT NULL,
  -- the purity of the compound in percentage as stated by the supplier
  "purity" real(8,2) DEFAULT NULL,
  -- the batch of the compound
  "batch" varchar(255) DEFAULT NULL,
  -- the date of the purchase
  "date" date DEFAULT NULL,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "purchase_uuid" ON "purchase" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:08 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "revision"
--
CREATE TABLE "revision" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "timestamp" timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  "remote_user" varchar(255) DEFAULT NULL,
  "server_addr" varchar(16) DEFAULT NULL,
  "server_name" varchar(255) DEFAULT NULL,
  "http_user_agent" varchar(512) DEFAULT NULL,
  "remote_addr" varchar(16) DEFAULT NULL,
  "http_host" varchar(255) DEFAULT NULL,
  "db_user" varchar(255) DEFAULT NULL,
  "env_text" text
);

CREATE UNIQUE INDEX "revision_uuid" ON "revision" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:09 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "sample_history"
--
CREATE TABLE "sample_history" (
-- Comments: 
-- history table of the "sample_history" table
--

  -- unique table key in the history table
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- sample identifier asigned by the SOLSA partner
  "SolsaID" char(12) DEFAULT NULL,
  -- sample acquisition date
  "acquisition_date" date DEFAULT NULL,
  -- name of the sample
  "name" varchar(255) DEFAULT NULL,
  -- subclass of the sample
  "kind" enum(9),
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:10 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "sample"
--
CREATE TABLE "sample" (
-- Comments: 
-- stores the general information about the sample
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- sample identifier asigned by the SOLSA partner
  "SolsaID" char(12) DEFAULT NULL,
  -- sample acquisition date
  "acquisition_date" date DEFAULT NULL,
  -- name of the sample
  "name" varchar(255) DEFAULT NULL,
  -- subclass of the sample
  "kind" enum(9),
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "sample_SolsaID" ON "sample" ("SolsaID");

CREATE UNIQUE INDEX "sample_uuid" ON "sample" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:11 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "sem_img_history"
--
CREATE TABLE "sem_img_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "caption" varchar(255) DEFAULT NULL,
  "image" MEDIUMBLOB(16777215) DEFAULT NULL,
  "format" enum(4) NOT NULL,
  -- image mimetype
  "mimetype" varchar(255) DEFAULT NULL,
  -- name of the CSS class that describes the way the image should be represented in (X)HTML
  "cssclass" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:11 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "sem_img"
--
CREATE TABLE "sem_img" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "caption" varchar(255) DEFAULT NULL,
  "image" MEDIUMBLOB(16777215) DEFAULT NULL,
  "format" enum(4) NOT NULL,
  -- image mimetype
  "mimetype" varchar(255) DEFAULT NULL,
  -- name of the CSS class that describes the way the image should be represented in (X)HTML
  "cssclass" varchar(255) DEFAULT NULL,
  FOREIGN KEY ("experiment_id") REFERENCES "experiment_sem"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "sem_img_experiment_id" ON "sem_img" ("experiment_id");

CREATE UNIQUE INDEX "sem_img_uuid" ON "sem_img" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:12 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "synthetic_sample_history"
--
CREATE TABLE "synthetic_sample_history" (
-- Comments: 
-- history table of the "synthetic_sample" table
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- unique table key in the original table
  "oldid" int(11) NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the entry creation revision
  "create_revision_id" int(11) DEFAULT NULL,
  -- id of the entry deletion revision
  "delete_revision_id" int(11) DEFAULT NULL,
  -- id of the related entry in the sample table
  "sample_id" int(11) NOT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:13 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "synthetic_sample"
--
CREATE TABLE "synthetic_sample" (
-- Comments: 
-- stores information about the synthetic sample
--

  -- unique table key
  "id" INTEGER PRIMARY KEY NOT NULL,
  -- universally unique identifier
  "uuid" char(36) DEFAULT NULL,
  -- id of the related entry in the revision table
  "revision_id" int(11) DEFAULT NULL,
  -- id of the related entry in the sample table
  "sample_id" int(11) NOT NULL,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("sample_id") REFERENCES "sample"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE UNIQUE INDEX "synthetic_sample_uuid" ON "synthetic_sample" ("uuid");

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:13 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "xrf_content_history"
--
CREATE TABLE "xrf_content_history" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "oldid" int(11) NOT NULL,
  "uuid" char(36) NOT NULL,
  "create_revision_id" int(11) DEFAULT NULL,
  "delete_revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "component" varchar(10) DEFAULT NULL,
  "value" real(8,2) DEFAULT NULL,
  FOREIGN KEY ("create_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("delete_revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

COMMIT;
-- 
-- Created by SQL::Translator::Producer::SQLite
-- Created on Fri Jan 26 11:26:14 2018
-- 

BEGIN TRANSACTION;

--
-- Table: "xrf_content"
--
CREATE TABLE "xrf_content" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "uuid" char(36) NOT NULL,
  "revision_id" int(11) DEFAULT NULL,
  "experiment_id" int(11) NOT NULL,
  "component" varchar(10) DEFAULT NULL,
  "value" real(8,2) DEFAULT NULL,
  FOREIGN KEY ("experiment_id") REFERENCES "experiment_xrf"("id") ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ("revision_id") REFERENCES "revision"("id") ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE INDEX "xrf_content_experiment_id" ON "xrf_content" ("experiment_id");

CREATE UNIQUE INDEX "xrf_content_uuid" ON "xrf_content" ("uuid");

COMMIT;
