<?xml version='1.0'?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:d="http://docbook.org/ns/docbook"
  xmlns:tei="http://www.tei-c.org/ns/1.0"
  exclude-result-prefixes="d tei">

<!--
	Description:
		XSL Stylesheet to extract RefDB citations.  The extracted
		citations are input into RefDB to build a cooked reference
		list for the document.  The output format conforms to
		the CitationList DTD.

                Please see the citationsraw.xsl stylesheet to process plain
                citations in contrast to the RefDB citations processed here.

                This file contains the code for both DocBook XML (V. 4.x
                and 5) and TEI XML (P4 and P5) documents. This is ok as
                long as element names do not overlap. Other DTD's could be
                taken care of in a similar way

                For DocBook V5 and TEI P5, both namespaced and non-namespaced
                documents are supposed to work

        Authors:
                initial version by Alan Anderson <alan at rushmore.com>
                extended and currently maintained by
                Markus Hoenicka <mhoenicka at users.sourceforge.net>
-->

<xsl:output method="xml" version='1.0' 
  doctype-public="-//Markus Hoenicka//DTD CitationList//EN" 
  doctype-system="http://refdb.sourceforge.net/dtd/citationlistx.dtd"/>

  <!-- the first part deals with DocBook XML documents -->

	<!-- look for citations in articles in Docbook -->
        <xsl:template match="article|d:article">
		<!-- insert a return after the doctype declaration -->
                <xsl:text>
</xsl:text>
		<!-- output the citationlist start tag -->
                <citationlist>
		<!-- output a newline and a tab -->
		<xsl:text>
                </xsl:text>
        <xsl:apply-templates select="//citation|//d:citation"/>
		</citationlist>
	</xsl:template>

	<!-- look for citations in books in Docbook -->
	<xsl:template match="book|d:book">
		<!-- insert a return after the doctype declaration -->
		<xsl:text>
</xsl:text>
		<!-- output the citationlist start tag -->
		<citationlist>
		<!-- output a newline and a tab -->
		<xsl:text>
	</xsl:text>
        <xsl:apply-templates select="//citation|//d:citation"/>
		</citationlist>
	</xsl:template>

	<!-- find the citations -->
  <xsl:template match="citation|d:citation">
		<!-- if the role attribute is REFDB then we continue looking,
			otherwise we quit -->
		<xsl:if test="@role='REFDB'">
			<!-- output opening tag -->
			<citation>
			<!-- look for sub tags -->
			<xsl:apply-templates/>
			</citation>
			<xsl:text>
	</xsl:text>
		</xsl:if>
  </xsl:template>

	<!-- find the xref tags -->
	<xsl:template match="xref|d:xref|biblioref|d:biblioref">
                <!-- two possibilities: a "regular" citation, or the special
                     citation ptr introducing a multiple citation. In both
                     cases the element contents are derived from a linkend
                     attribute. We have to strip off the last character
                     denoting the type and the preceeding separator -->
                <xsl:choose>
                  <xsl:when test="@role='MULTIXREF'">
                    <!-- copy through the value of the endterm attribute.
                         This one does not have a trailing
                         type specifier so we don't have to strip -->
                    <xref endterm="{@endterm}">
                      <!-- use the value of the linkend attribute as the
                           element contents, no type specifier either -->
                      <xsl:value-of select="@linkend"/>
                    </xref>
                  </xsl:when>
                  <xsl:otherwise>
                    <!-- a regular citation ptr. Use the value of the linkend
                         attribute as the element contents -->
                    <xref>
                      <xsl:value-of select="substring(@linkend,1,string-length(@linkend) -2)"/>
                    </xref>
                  </xsl:otherwise>
                </xsl:choose>
		<xsl:text>
		</xsl:text>
	</xsl:template>

        <!-- end of the DocBook XML part -->

        <!-- the second part is for TEI XML documents -->

	<!-- look for citations in TEI documents -->
	<xsl:template match="TEI.2|tei:TEI">
		<!-- insert a return after the doctype declaration -->
		<xsl:text>
</xsl:text>
		<!-- output the citationlist start tag -->
		<citationlist>
		<!-- output a newline and a tab -->
		<xsl:text>
	</xsl:text>
        <xsl:apply-templates select="//seg|//tei:seg"/>
		</citationlist>
	</xsl:template>

	<!-- find the citations -->
  <xsl:template match="seg|tei:seg">
		<!-- if the role attribute is REFDBCITATION then we continue looking,
			otherwise we quit -->
		<xsl:if test="@type='REFDBCITATION'">
			<!-- output opening tag -->
			<citation>
			<!-- look for sub tags -->
			<xsl:apply-templates/>
			</citation>
			<xsl:text>
	</xsl:text>
		</xsl:if>
  </xsl:template>

	<!-- find the ptr tags -->
	<xsl:template match="ptr|tei:ptr">
                <!-- two possibilities: a "regular" citation, or the special
                     citation ptr introducing a multiple citation. In both
                     cases the element contents are derived from a target
                     attribute. We have to strip off the last character
                     denoting the type and the preceeding separator -->
                <xsl:choose>
                  <xsl:when test="@type='MULTIXREF'">
                    <!-- output the value of the target attribute as the
                         endterm attribute. This one does not have a trailing
                         type specifier so we don't have to strip -->
                    <xref endterm="{@target}">
                      <!-- use the value of the target attribute of the
                           *following* ptr element as the element contents -->
                      <xsl:value-of select="substring(following-sibling::ptr/@target,1,string-length(following-sibling::ptr/@target) -2)"/>
                    </xref>
                  </xsl:when>
                  <xsl:otherwise>
                    <!-- a regular citation ptr. Use the value of the target
                         attribute as the element contents -->
                    <xref>
                      <xsl:value-of select="substring(@target,1,string-length(@target) -2)"/>
                    </xref>
                  </xsl:otherwise>
                </xsl:choose>
		<xsl:text>
		</xsl:text>
	</xsl:template>

        <xsl:template match="*">
          <!-- suppress everything else -->
        </xsl:template>
</xsl:stylesheet>
