/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  xmlhelper.h header for xmlhelper.c
  markus@mhoenicka.de 2003-10-15

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
   
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
   
  You should have received a copy of the GNU General Public License
  along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#define INDENT_MAX 14 /* unit is character for both */
#define INDENT_INC 2
#define STRINGIFY(v) #v

struct xmlindent {
  int indent_current;
  int maybe_in_leaf;
  int indent_toodeep;
  int inline_mode; /* if not 0, no linebreaks and no indentation */
  char indent_string[INDENT_MAX+2]; /* +1 for '<', +1 for '\0' */
  int (*notbelow)(const char*); /* ptr to fn that tests whether or not to
				   indent */
  int (*isentry)(const char*); /* ptr to fn that tests whether this is
				  a main entry */
};

char* print_element_x(const char* elvalue, char** ptr_buffer, size_t* ptr_buflen, const char* elname, const char* attname, const char* attvalue, const char* attname1, const char* attvalue1, struct xmlindent* ptr_indent, const char* namespace);
char* print_elstart_x(char** ptr_buffer, size_t* ptr_buflen, const char* elname, const char* attname, const char* attvalue, const char* attname1, const char* attvalue1, const char* attname2, const char* attvalue2, const char* attname3, const char* attvalue3, const char* attname4, const char* attvalue4, int is_empty, struct xmlindent* ptr_indent, const char* namespace);
char* print_elend_x(char** ptr_buffer, size_t* ptr_buflen, const char* elname, struct xmlindent* ptr_indent, const char* namespace);
char* print_attribute_x(char** ptr_buffer, size_t* ptr_buflen, const char* attname, const char* attvalue);
int initialize_xmlindent(struct xmlindent* ptr_xindent, int indent_current, int (*notbelow)(const char*), int (*isentry)(const char*));
int inline_xmlindent(struct xmlindent* ptr_xindent, int n_inline);
