% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-expression.R
\name{label_parse}
\alias{label_parse}
\alias{label_math}
\alias{parse_format}
\alias{math_format}
\title{Label with mathematical annotations}
\usage{
label_parse()

label_math(expr = 10^.x, format = force)

parse_format()

math_format(expr = 10^.x, format = force)
}
\arguments{
\item{expr}{expression to use}

\item{format}{another format function to apply prior to mathematical
transformation - this makes it easier to use floating point numbers in
mathematical expressions.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
\code{label_parse()} produces expression from strings by parsing them;
\code{label_math()} constructs expressions by replacing the pronoun \code{.x}
with each string.
}
\section{Old interface}{

\code{parse_format()} and \code{math_format()} was retired; please use
\code{label_parse()} and \code{label_math()} instead.
}

\examples{
# Use label_parse() with discrete scales
greek <- c("alpha", "beta", "gamma")
demo_discrete(greek)
demo_discrete(greek, labels = label_parse())

# Use label_math() with continuous scales
demo_continuous(c(1, 5))
demo_continuous(c(1, 5), labels = label_math(alpha[.x]))
}
\seealso{
\link{plotmath} for the details of mathematical formatting in R.

Other labels for continuous scales: \code{\link{label_bytes}},
  \code{\link{label_dollar}},
  \code{\link{label_number_auto}},
  \code{\link{label_number_si}},
  \code{\link{label_ordinal}}, \code{\link{label_percent}},
  \code{\link{label_pvalue}},
  \code{\link{label_scientific}}

Other labels for discrete scales: \code{\link{label_wrap}}
}
\concept{labels for continuous scales}
\concept{labels for discrete scales}
