% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{scores}
\alias{scores}
\alias{loadings}
\alias{scores.default}
\alias{loadings.default}
\alias{loading.weights}
\alias{Yscores}
\alias{Yloadings}
\title{Extract Scores and Loadings from PLSR and PCR Models}
\usage{
loadings(object, ...)

\method{loadings}{default}(object, ...)

scores(object, ...)

\method{scores}{default}(object, ...)

Yscores(object)

loading.weights(object)

Yloadings(object)
}
\arguments{
\item{object}{a fitted model to extract from.}

\item{\dots}{extra arguments, currently not used.}
}
\value{
A matrix with scores or loadings.
}
\description{
These functions extract score and loading matrices from fitted \code{mvr}
models.
}
\details{
All functions extract the indicated matrix from the fitted model, and will
work with any object having a suitably named component.

The default \code{scores} and \code{loadings} methods also handle
\code{prcomp} objects (their scores and loadings components are called
\code{x} and \code{rotation}, resp.), and add an attribute \code{"explvar"}
with the variance explained by each component, if this is available.  (See
\code{\link{explvar}} for details.)
}
\note{
There is a \code{loadings} function in package \pkg{stats}.  It simply
returns any element named \code{"loadings"}.  See
\code{\link[stats]{loadings}} for details.  The function can be accessed as
\code{stats::loadings(...)}.
}
\examples{

data(yarn)
plsmod <- plsr(density ~ NIR, 6, data = yarn)
scores(plsmod)
loadings(plsmod)[,1:4]

}
\seealso{
\code{\link{mvr}}, \code{\link{coef.mvr}}
}
\author{
Ron Wehrens and Bjørn-Helge Mevik
}
\keyword{multivariate}
\keyword{regression}
