% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-fitdistr.R
\name{tidy.fitdistr}
\alias{tidy.fitdistr}
\alias{fitdistr_tidiers}
\title{Tidy a(n) fitdistr object}
\usage{
\method{tidy}{fitdistr}(x, ...)
}
\arguments{
\item{x}{A \code{fitdistr} object returned by \code{\link[MASS:fitdistr]{MASS::fitdistr()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed("MASS")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(MASS)

# generate data
set.seed(2015)
x <- rnorm(100, 5, 2)

#  fit models
fit <- fitdistr(x, dnorm, list(mean = 3, sd = 1))

# summarize model fit with tidiers
tidy(fit)
glance(fit)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[MASS:fitdistr]{MASS::fitdistr()}}

Other fitdistr tidiers: 
\code{\link{glance.fitdistr}()}
}
\concept{fitdistr tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{estimate}{The estimated value of the regression term.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
