Converting arrays
   - NumPy
   - Python objects
   - JSON
   - ROOT via Uproot
   - Parquet via Arrow
   - Pandas: Awkward columns
   - Pandas: as MultiIndex
   - Zarr

Creating arrays
   - ArrayBuilder (easy & general)
   - Layout (faster)
   - Lazy arrays and Dask

Examining arrays
   - Data type
   - Single item detail
   - Listing fields/keys/columns
   - Simple slicing
   - Checking validity

Numerical math
   - NumPy functions
   - Awkward broadcasting
   - Reducing (sum/min/any/all)
   - Statistics (mean/var/std)
   - Using argmin/argmax
   - On GPUs

Filtering data
   - By number of items
   - Cuts vs. masks
   - Slicing lists within arrays
   - Slices with missing values

Restructuring data
   - Zip/unzip and project
   - Adding fields to records
   - Renaming records
   - Flattening for plots
   - Padding/clipping for machine learning
   - Concatenating and interleaving
   - Sorting

Combinatorics
   - Cartesian/cross product and "n choose k"
   - Best match between collections

Specialized behavior
   - Subclassing Array/Record
   - Overriding NumPy functions
   - In Numba
   - For physics: Lorentz vectors
