/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __PLANFACILE__
#define __PLANFACILE__

#include <src/global/global.h>

#include <src/donnees/general/general.h>
#include <src/donnees/environnement/environnement.h>
#include <src/messages/messages/sources/messages.h>

#include <src/messages/special/aide.h>
#include <src/messages/special/licence.h>

#include <src/analyseur/analyseur/analyse.h>
#include <src/passes/retouches/retouches.h>
#include <src/passes/options/reductionoptions.h>
#include <src/passes/macros/reductionmacros.h>
#include <src/passes/verification/verification.h>
#include <src/passes/styles/enregistrementstyles.h>
#include <src/passes/idees/enregistrementidees.h>
#include <src/passes/plan/plan.h>
#include <src/passes/sortie/sortie.h>

Resultat planfacile_planfacile(TRAVAIL(General) general , int argc , char *argv[]);
/* Fonction de compilation de planfacile.
 * Cette fonction est appelle directement par main()
 * et s'occupe de tout.
 * La fonction renvoit un rsultat diffrent de RESULTAT_OK
 * en cas d'erreur.
 */

#endif
