/**
 * Temporary - The lord of tmp.
 *
 * Author: Veselin Todorov <hi@vesln.com>
 * Licensed under the MIT License.
 */

/**
 * Dependencies.
 */
var fs = require('fs');
var path = require('path');
var generator = require('./generator');
var detector = require('./detector');
var Base = require('./base');

/**
 * Dir constructor.
 *
 * @param {String|null} name
 * @param {Object} [options] Overrides for directory naming
 */
function Dir(name, options) {
  this.init(name, options);
}

/**
 * Dir extends from tmp.
 */
Object.setPrototypeOf(Dir.prototype, Base.prototype);

/**
 * Creates new file.
 *
 * @param {String} dirname
 */
Dir.prototype.create = function(dirname) {
  return fs.mkdirSync(path.normalize(dirname), 0700); //0700 we can read,write and execute
};

/**
 * Asynchronous dir.
 */
Dir.prototype.rmdir = function() {
  fs.rmdir.apply(fs, this.prepareArgs(arguments, [function(err) {throw Error(err)}]));
};

/**
 * Synchronous rmdir.
 */
Dir.prototype.rmdirSync = function() {
  return fs.rmdirSync.apply(fs, this.prepareArgs(arguments));
};

/**
 * Exporting the lib.
 */
module.exports = Dir;
