"""
@package vdigit.main

@brief wxGUI vector digitizer

Classes:
 - main::VDigit

(C) 2007-2012 by the GRASS Development Team

This program is free software under the GNU General Public License
(>=v2). Read the file COPYING that comes with GRASS for details.

@author Martin Landa <landa.martin gmail.com>
"""

try:
    from vdigit.wxdigit import IVDigit, GV_LINES, CFUNCTYPE  # noqa: F401

    haveVDigit = True
    errorMsg = ""
except (ImportError, NameError) as err:
    haveVDigit = False
    errorMsg = err
    GV_LINES = -1

    class IVDigit:
        def __init__(self):
            pass


class VDigit(IVDigit):
    def __init__(self, giface, mapwindow):
        """Base class of vector digitizer

        :param giface: reference to a grass interface instance
        :param mapwindow: reference to a map window instance
        """
        IVDigit.__init__(self, giface, mapwindow)
