/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl-plugin.h>
#include <gegl.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpcontainer.h"
#include "core/gimpdrawable-filters.h"
#include "core/gimpdrawable.h"
#include "core/gimpdrawablefilter.h"
#include "core/gimpimage-undo-push.h"
#include "core/gimpitem.h"
#include "core/gimpparamspecs.h"
#include "operations/gimp-operation-config.h"
#include "operations/gimpoperationsettings.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
drawable_filter_id_is_valid_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint filter_id;
  gboolean valid = FALSE;

  filter_id = g_value_get_int (gimp_value_array_index (args, 0));

  if (success)
    {
      valid = (gimp_drawable_filter_get_by_id (gimp, filter_id) != NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), valid);

  return return_vals;
}

static GimpValueArray *
drawable_filter_new_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawable *drawable;
  const gchar *operation_name;
  const gchar *name;
  GimpDrawableFilter *filter = NULL;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  operation_name = g_value_get_string (gimp_value_array_index (args, 1));
  name = g_value_get_string (gimp_value_array_index (args, 2));

  if (success)
    {
      GType op_type;

      /* Comes from gegl/operation/gegl-operations.h which is not public. */
      GType gegl_operation_gtype_from_name (const gchar *name);

      op_type = gegl_operation_gtype_from_name (operation_name);
      /* Using the same rules as in xcf_load_effect() for plug-in created
       * effects.
       */
      if (g_type_is_a (op_type, GEGL_TYPE_OPERATION_SINK))
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       "%s: the filter \"%s\" is unsafe.",
                       G_STRFUNC, operation_name);

          success = FALSE;
        }
      else if (g_strcmp0 (operation_name, "gegl:gegl") == 0 &&
               g_getenv ("GIMP_ALLOW_GEGL_GRAPH_LAYER_EFFECT") == NULL)
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       "%s: the filter \"gegl:gegl\" is unsafe.\n"
                       "For development purpose, set environment variable GIMP_ALLOW_GEGL_GRAPH_LAYER_EFFECT.",
                       G_STRFUNC);

          success = FALSE;
        }

      if (! gegl_has_operation (operation_name) || ! g_strcmp0 (operation_name, "gegl:nop"))
        {
          if (! g_strcmp0 (operation_name, "gegl:nop"))
            g_set_error_literal (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                                 "The filter \"gegl:nop\" is useless and not allowed.");
          else
            g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                         "%s: the filter \"%s\" is not installed.",
                         G_STRFUNC, operation_name);

          success = FALSE;
        }

      if (success)
        {
          GeglNode *operation = gegl_node_new ();

          gegl_node_set (operation,
                         "operation", operation_name,
                         NULL);
          filter = gimp_drawable_filter_new (drawable, name, operation, NULL);
          /* We don't have a libgimp function for setting the clipping
           * behavior. I want to look further into the whole logic first.
           * In the meantime if all API-made filters must have a single
           * clipping behavior, I believe that not-clipping (adjusting) is
           * the nicer default.
           */
          gimp_drawable_filter_set_clip (filter, FALSE);
          g_clear_object (&operation);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), filter);

  return return_vals;
}

static GimpValueArray *
drawable_filter_get_name_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gchar *name = NULL;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      name = g_strdup (gimp_object_get_name (GIMP_OBJECT (filter)));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
drawable_filter_get_operation_name_invoker (GimpProcedure         *procedure,
                                            Gimp                  *gimp,
                                            GimpContext           *context,
                                            GimpProgress          *progress,
                                            const GimpValueArray  *args,
                                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gchar *name = NULL;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GeglNode *node;

      node = gimp_drawable_filter_get_operation (filter);
      name = g_strdup (gegl_node_get_operation (node));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), name);

  return return_vals;
}

static GimpValueArray *
drawable_filter_get_visible_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gboolean visible = FALSE;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      visible = gimp_filter_get_active (GIMP_FILTER (filter));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), visible);

  return return_vals;
}

static GimpValueArray *
drawable_filter_set_visible_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpDrawableFilter *filter;
  gboolean visible;

  filter = g_value_get_object (gimp_value_array_index (args, 0));
  visible = g_value_get_boolean (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_filter_set_active (GIMP_FILTER (filter), visible);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
drawable_filter_get_opacity_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gdouble opacity = 0.0;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      opacity = gimp_drawable_filter_get_opacity (filter);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), opacity);

  return return_vals;
}

static GimpValueArray *
drawable_filter_get_blend_mode_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gint mode = 0;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      mode = gimp_drawable_filter_get_paint_mode (filter);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), mode);

  return return_vals;
}

static GimpValueArray *
drawable_filter_update_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpDrawableFilter *filter;
  const gchar **propnames;
  const GimpValueArray *propvalues;
  gdouble opacity;
  gint blend_mode;
  gint blend_space;
  gint composite_mode;
  gint composite_space;
  const gchar **auxinputnames;
  const GimpDrawable **auxinputs;

  filter = g_value_get_object (gimp_value_array_index (args, 0));
  propnames = g_value_get_boxed (gimp_value_array_index (args, 1));
  propvalues = g_value_get_boxed (gimp_value_array_index (args, 2));
  opacity = g_value_get_double (gimp_value_array_index (args, 3));
  blend_mode = g_value_get_enum (gimp_value_array_index (args, 4));
  blend_space = g_value_get_enum (gimp_value_array_index (args, 5));
  composite_mode = g_value_get_enum (gimp_value_array_index (args, 6));
  composite_space = g_value_get_enum (gimp_value_array_index (args, 7));
  auxinputnames = g_value_get_boxed (gimp_value_array_index (args, 8));
  auxinputs = g_value_get_boxed (gimp_value_array_index (args, 9));

  if (success)
    {
      success = gimp_drawable_filter_update (filter, propnames, propvalues,
                                             opacity,
                                             blend_mode, blend_space,
                                             composite_mode, composite_space,
                                             auxinputnames, auxinputs,
                                             error);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
drawable_filter_get_number_arguments_invoker (GimpProcedure         *procedure,
                                              Gimp                  *gimp,
                                              GimpContext           *context,
                                              GimpProgress          *progress,
                                              const GimpValueArray  *args,
                                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gint num_args = 0;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GeglNode    *node;
      const gchar *opname;

      node   = gimp_drawable_filter_get_operation (filter);
      opname = gegl_node_get_operation (node);

      if (gegl_has_operation (opname))
        {
          guint n_properties;

          if (gimp_operation_config_is_custom (gimp, opname))
            {
              GimpObject   *settings = NULL;
              GObjectClass *klass;
              GObjectClass *parent_klass;
              guint         n_parent_properties;

              gegl_node_get (node,
                             "config", &settings,
                             NULL);
              klass        = G_OBJECT_GET_CLASS (settings);
              parent_klass = G_OBJECT_CLASS (g_type_class_peek_parent (klass));

              g_free (g_object_class_list_properties (parent_klass, &n_parent_properties));
              g_free (g_object_class_list_properties (klass, &n_properties));
              g_clear_object (&settings);
              n_properties -= n_parent_properties;
            }
          else
            {
              g_free (gegl_operation_list_properties (opname, &n_properties));
            }

          num_args = (gint) n_properties;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), num_args);

  return return_vals;
}

static GimpValueArray *
drawable_filter_get_pspec_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gint arg_num;
  GParamSpec *param_spec = NULL;

  filter = g_value_get_object (gimp_value_array_index (args, 0));
  arg_num = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpObject  *settings = NULL;
      GeglNode    *node;
      const gchar *opname;

      node   = gimp_drawable_filter_get_operation (filter);
      opname = gegl_node_get_operation (node);

      if (gegl_has_operation (opname))
        {
          GParamSpec  **specs;
          guint         n_properties;
          guint         n_parent_properties = 0;

          if (gimp_operation_config_is_custom (gimp, opname))
            {
              GObjectClass *klass;
              GObjectClass *parent_klass;

              gegl_node_get (node,
                             "config", &settings,
                             NULL);
              klass        = G_OBJECT_GET_CLASS (settings);
              parent_klass = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
              g_free (g_object_class_list_properties (parent_klass, &n_parent_properties));
            }

          if (settings != NULL)
            specs = g_object_class_list_properties (G_OBJECT_GET_CLASS (settings), &n_properties);
          else
            specs = gegl_operation_list_properties (opname, &n_properties);

          if (arg_num >= 0 && n_parent_properties + arg_num < n_properties)
            {
              param_spec = g_param_spec_ref (specs[n_parent_properties + arg_num]);
            }
          else
            {
              success = FALSE;
            }

          g_free (specs);
        }
      else
        {
          success = FALSE;
        }

      g_clear_object (&settings);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_param (gimp_value_array_index (return_vals, 1), param_spec);

  return return_vals;
}

static GimpValueArray *
drawable_filter_get_arguments_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpDrawableFilter *filter;
  gchar **argnames = NULL;
  GimpValueArray *values = NULL;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GeglNode     *node;
      const gchar  *opname;
      GParamSpec  **specs;
      guint         n_specs;
      guint         n_parent_properties = 0;
      GStrvBuilder *names_builder;
      GimpObject   *settings = NULL;

      node   = gimp_drawable_filter_get_operation (filter);
      opname = gegl_node_get_operation (node);

      if (gegl_has_operation (opname) &&
          gimp_operation_config_is_custom (gimp, opname))
        {
          GObjectClass *klass;
          GObjectClass *parent_klass;

          gegl_node_get (node,
                         "config", &settings,
                         NULL);
          klass        = G_OBJECT_GET_CLASS (settings);
          parent_klass = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
          g_free (g_object_class_list_properties (parent_klass, &n_parent_properties));
        }

      if (settings != NULL)
        {
          specs = g_object_class_list_properties (G_OBJECT_GET_CLASS (settings), &n_specs);
          n_specs -= n_parent_properties;
        }
      else
       {
         specs = gegl_operation_list_properties (opname, &n_specs);
       }

      names_builder = g_strv_builder_new ();
      values        = gimp_value_array_new (n_specs);

      for (gint i = 0; i < n_specs; i++)
        {
          GParamSpec *pspec = specs[n_parent_properties + i];
          GValue      value = G_VALUE_INIT;

          g_value_init (&value, pspec->value_type);
          if (settings != NULL)
            g_object_get_property (G_OBJECT (settings), pspec->name, &value);
          else
            gegl_node_get_property (node, pspec->name, &value);

          if (GEGL_IS_PARAM_SPEC_ENUM (pspec))
            {
              /* Special-casing GeglParamEnum which are passed as string to
               * libgimp.
               */
              GParamSpecEnum *espec       = G_PARAM_SPEC_ENUM (pspec);
              GEnumClass     *enum_class  = espec->enum_class;
              GValue         string_value = G_VALUE_INIT;
              gint           int_enum     = g_value_get_enum (&value);

              g_value_init (&string_value, G_TYPE_STRING);
              for (gint j = 0; j < enum_class->n_values; j++)
                {
                  GEnumValue enum_value = enum_class->values[j];

                  if (enum_value.value < enum_class->minimum || enum_value.value > enum_class->maximum)
                    continue;

                  if (enum_value.value == espec->default_value)
                    g_value_set_string (&string_value, enum_value.value_nick);
                }

              for (gint j = 0; j < enum_class->n_values; j++)
                {
                  GEnumValue enum_value = enum_class->values[j];

                  if (enum_value.value == int_enum)
                    g_value_set_string (&string_value, enum_value.value_nick);
                }

              gimp_value_array_append (values, &string_value);
              g_value_unset (&string_value);
            }
          else
            {
              gimp_value_array_append (values, &value);
            }
          g_strv_builder_add (names_builder, pspec->name);
          g_value_unset (&value);
        }

      argnames = g_strv_builder_end (names_builder);

      g_strv_builder_unref (names_builder);
      g_free (specs);
      g_clear_object (&settings);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_take_boxed (gimp_value_array_index (return_vals, 1), argnames);
      g_value_take_boxed (gimp_value_array_index (return_vals, 2), values);
    }

  return return_vals;
}

static GimpValueArray *
drawable_filter_delete_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpDrawableFilter *filter;

  filter = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpDrawable *drawable = gimp_drawable_filter_get_drawable (filter);

      if (drawable && gimp_drawable_has_filter (drawable, GIMP_FILTER (filter)))
        {
          gimp_image_undo_push_filter_remove (gimp_item_get_image (GIMP_ITEM (drawable)),
                                              _("Remove filter"), drawable, filter);

          gimp_drawable_filter_abort (filter);
        }
      else
        {
          g_clear_object (&filter);
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_drawable_filter_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-drawable-filter-id-is-valid
   */
  procedure = gimp_procedure_new (drawable_filter_id_is_valid_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-id-is-valid");
  gimp_procedure_set_static_help (procedure,
                                  "Returns %TRUE if the drawable filter ID is valid.",
                                  "This procedure checks if the given drawable filter ID is valid and refers to an existing filter.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("filter-id",
                                                 "filter id",
                                                 "The filter ID to check",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("valid",
                                                         "valid",
                                                         "Whether the filter ID is valid",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-new
   */
  procedure = gimp_procedure_new (drawable_filter_new_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-new");
  gimp_procedure_set_static_help (procedure,
                                  "Create a new drawable filter.",
                                  "This procedure creates a new filter for the specified operation on @drawable.\n"
                                  "The new effect still needs to be either added or merged to @drawable later. Add the effect non-destructively with [method@Gimp.Drawable.append_filter].\n"
                                  "Currently only layers can have non-destructive effects. The effects must be merged for all other types of drawable.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("operation-name",
                                                       "operation name",
                                                       "The GEGL operation's name",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The effect name",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_filter ("filter",
                                                                    "filter",
                                                                    "The newly created filter",
                                                                    FALSE,
                                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-name
   */
  procedure = gimp_procedure_new (drawable_filter_get_name_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-name");
  gimp_procedure_set_static_help (procedure,
                                  "Get a drawable filter's name.",
                                  "This procedure returns the specified filter's name.\n"
                                  "Since it is not possible to set a drawable filter's name yet, this will be the operation's name. Eventually this filter's name will be a free form field so do not rely on this information for any processing.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter whose name you want",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The filter's name",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-operation-name
   */
  procedure = gimp_procedure_new (drawable_filter_get_operation_name_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-operation-name");
  gimp_procedure_set_static_help (procedure,
                                  "Get a drawable filter's operation name.",
                                  "This procedure returns the specified filter's operation name.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter whose operation name you want",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The filter's operation name",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-visible
   */
  procedure = gimp_procedure_new (drawable_filter_get_visible_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-visible");
  gimp_procedure_set_static_help (procedure,
                                  "Get the visibility of the specified filter.",
                                  "This procedure returns the specified filter's visibility.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("visible",
                                                         "visible",
                                                         "The filter visibility",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-set-visible
   */
  procedure = gimp_procedure_new (drawable_filter_set_visible_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-set-visible");
  gimp_procedure_set_static_help (procedure,
                                  "Set the visibility of the specified filter.",
                                  "This procedure sets the specified filter's visibility.\n"
                                  "The drawable won't be immediately rendered. Use [method@Gimp.Drawable.update] to trigger an update.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("visible",
                                                     "visible",
                                                     "The new filter visibility",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-opacity
   */
  procedure = gimp_procedure_new (drawable_filter_get_opacity_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-opacity");
  gimp_procedure_set_static_help (procedure,
                                  "Get the opacity of the specified filter.",
                                  "This procedure returns the specified filter's opacity.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("opacity",
                                                        "opacity",
                                                        "The filter's opacity",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-blend-mode
   */
  procedure = gimp_procedure_new (drawable_filter_get_blend_mode_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-blend-mode");
  gimp_procedure_set_static_help (procedure,
                                  "Get the blending mode of the specified filter.",
                                  "This procedure returns the specified filter's mode.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("mode",
                                                      "mode",
                                                      "The effect blending mode",
                                                      GIMP_TYPE_LAYER_MODE,
                                                      GIMP_LAYER_MODE_NORMAL_LEGACY,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-update
   */
  procedure = gimp_procedure_new (drawable_filter_update_invoker, TRUE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-update");
  gimp_procedure_set_static_help (procedure,
                                  "Update the settings of the specified filter.",
                                  "This procedure updates the settings of the specified filter all at once.\n"
                                  "In particular, update will be frozen and will happen only once for all changed settings.\n"
                                  "This PDB function is internal, meant to be private and its arguments will likely change as filters evolve. It should not be used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boxed ("propnames",
                                                   "propnames",
                                                   "Array of property names",
                                                   G_TYPE_STRV,
                                                   GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_value_array ("propvalues",
                                                            "propvalues",
                                                            "Array of values, one per property in propnames",
                                                            NULL,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The filter's opacity",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("blend-mode",
                                                  "blend mode",
                                                  "The effect blending mode",
                                                  GIMP_TYPE_LAYER_MODE,
                                                  GIMP_LAYER_MODE_NORMAL,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("blend-space",
                                                  "blend space",
                                                  "The effect blending space",
                                                  GIMP_TYPE_LAYER_COLOR_SPACE,
                                                  GIMP_LAYER_COLOR_SPACE_AUTO,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("composite-mode",
                                                  "composite mode",
                                                  "The layer composite mode",
                                                  GIMP_TYPE_LAYER_COMPOSITE_MODE,
                                                  GIMP_LAYER_COMPOSITE_AUTO,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("composite-space",
                                                  "composite space",
                                                  "The effect composite space",
                                                  GIMP_TYPE_LAYER_COLOR_SPACE,
                                                  GIMP_LAYER_COLOR_SPACE_AUTO,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boxed ("auxinputnames",
                                                   "auxinputnames",
                                                   "Array of aux input pads",
                                                   G_TYPE_STRV,
                                                   GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_core_object_array ("auxinputs",
                                                                  "auxinputs",
                                                                  "Array of drawables, one per auxinputnames",
                                                                  GIMP_TYPE_DRAWABLE,
                                                                  GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-number-arguments
   */
  procedure = gimp_procedure_new (drawable_filter_get_number_arguments_invoker, TRUE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-number-arguments");
  gimp_procedure_set_static_help (procedure,
                                  "Queries for the number of arguments on the specified filter.",
                                  "This procedure returns the number of arguments on the specified filter.\n"
                                  "For specific information on each input argument, use 'gimp-drawable-filter-get-argument'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-args",
                                                     "num args",
                                                     "The number of input arguments",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-pspec
   */
  procedure = gimp_procedure_new (drawable_filter_get_pspec_invoker, TRUE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-pspec");
  gimp_procedure_set_static_help (procedure,
                                  "Queries for information on the specified filter's argument.",
                                  "This procedure returns the #GParamSpec of filter's argument.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("arg-num",
                                                 "arg num",
                                                 "The argument number",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_param ("param-spec",
                                                       "param spec",
                                                       "The GParamSpec of the argument",
                                                       G_TYPE_PARAM,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-get-arguments
   */
  procedure = gimp_procedure_new (drawable_filter_get_arguments_invoker, TRUE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-get-arguments");
  gimp_procedure_set_static_help (procedure,
                                  "Returns the currently set filter arguments.",
                                  "This procedure returns the filter's arguments.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boxed ("argnames",
                                                       "argnames",
                                                       "The names of the arguments",
                                                       G_TYPE_STRV,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_value_array ("values",
                                                                "values",
                                                                "The values of the arguments in same order",
                                                                NULL,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-filter-delete
   */
  procedure = gimp_procedure_new (drawable_filter_delete_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-drawable-filter-delete");
  gimp_procedure_set_static_help (procedure,
                                  "Delete a drawable filter.",
                                  "This procedure deletes the specified filter. This must not be done if the drawable whose this filter was applied to was already deleted or if the drawable was already removed from the image.\n"
                                  "Do not use anymore the @filter object after having deleted it.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2024");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_filter ("filter",
                                                                "filter",
                                                                "The filter to delete",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
