/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimptransformtools_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"
#undef GIMP_DISABLE_DEPRECATED
#undef __GIMP_TRANSFORM_TOOLS_PDB_H__
#include "gimptransformtools_pdb.h"


/**
 * SECTION: gimptransformtools
 * @title: gimptransformtools
 * @short_description: Access to toolbox transform tools.
 *
 * Functions giving access to toolbox transform tools.
 **/


/**
 * gimp_flip:
 * @drawable_ID: The affected drawable.
 * @flip_type: Type of flip.
 *
 * Deprecated: Use gimp_item_transform_flip_simple() instead.
 *
 * Returns: The flipped drawable.
 **/
gint32
gimp_flip (gint32              drawable_ID,
           GimpOrientationType flip_type)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp-flip",
                                    &nreturn_vals,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_INT32, flip_type,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_perspective:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @x0: The new x coordinate of upper-left corner of original bounding box.
 * @y0: The new y coordinate of upper-left corner of original bounding box.
 * @x1: The new x coordinate of upper-right corner of original bounding box.
 * @y1: The new y coordinate of upper-right corner of original bounding box.
 * @x2: The new x coordinate of lower-left corner of original bounding box.
 * @y2: The new y coordinate of lower-left corner of original bounding box.
 * @x3: The new x coordinate of lower-right corner of original bounding box.
 * @y3: The new y coordinate of lower-right corner of original bounding box.
 *
 * Deprecated: Use gimp_item_transform_perspective() instead.
 *
 * Returns: The newly mapped drawable.
 **/
gint32
gimp_perspective (gint32   drawable_ID,
                  gboolean interpolation,
                  gdouble  x0,
                  gdouble  y0,
                  gdouble  x1,
                  gdouble  y1,
                  gdouble  x2,
                  gdouble  y2,
                  gdouble  x3,
                  gdouble  y3)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp-perspective",
                                    &nreturn_vals,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_INT32, interpolation,
                                    GIMP_PDB_FLOAT, x0,
                                    GIMP_PDB_FLOAT, y0,
                                    GIMP_PDB_FLOAT, x1,
                                    GIMP_PDB_FLOAT, y1,
                                    GIMP_PDB_FLOAT, x2,
                                    GIMP_PDB_FLOAT, y2,
                                    GIMP_PDB_FLOAT, x3,
                                    GIMP_PDB_FLOAT, y3,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_rotate:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @angle: The angle of rotation (radians).
 *
 * Deprecated: Use gimp_item_transform_rotate() instead.
 *
 * Returns: The rotated drawable.
 **/
gint32
gimp_rotate (gint32   drawable_ID,
             gboolean interpolation,
             gdouble  angle)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp-rotate",
                                    &nreturn_vals,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_INT32, interpolation,
                                    GIMP_PDB_FLOAT, angle,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_scale:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @x0: The new x coordinate of the upper-left corner of the scaled region.
 * @y0: The new y coordinate of the upper-left corner of the scaled region.
 * @x1: The new x coordinate of the lower-right corner of the scaled region.
 * @y1: The new y coordinate of the lower-right corner of the scaled region.
 *
 * Deprecated: Use gimp_item_transform_scale() instead.
 *
 * Returns: The scaled drawable.
 **/
gint32
gimp_scale (gint32   drawable_ID,
            gboolean interpolation,
            gdouble  x0,
            gdouble  y0,
            gdouble  x1,
            gdouble  y1)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp-scale",
                                    &nreturn_vals,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_INT32, interpolation,
                                    GIMP_PDB_FLOAT, x0,
                                    GIMP_PDB_FLOAT, y0,
                                    GIMP_PDB_FLOAT, x1,
                                    GIMP_PDB_FLOAT, y1,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_shear:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @shear_type: Type of shear.
 * @magnitude: The magnitude of the shear.
 *
 * Deprecated: Use gimp_item_transform_shear() instead.
 *
 * Returns: The sheared drawable.
 **/
gint32
gimp_shear (gint32              drawable_ID,
            gboolean            interpolation,
            GimpOrientationType shear_type,
            gdouble             magnitude)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp-shear",
                                    &nreturn_vals,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_INT32, interpolation,
                                    GIMP_PDB_INT32, shear_type,
                                    GIMP_PDB_FLOAT, magnitude,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}

/**
 * gimp_transform_2d:
 * @drawable_ID: The affected drawable.
 * @interpolation: Whether to use interpolation.
 * @source_x: X coordinate of the transformation center.
 * @source_y: Y coordinate of the transformation center.
 * @scale_x: Amount to scale in x direction.
 * @scale_y: Amount to scale in y direction.
 * @angle: The angle of rotation (radians).
 * @dest_x: X coordinate of where the centre goes.
 * @dest_y: Y coordinate of where the centre goes.
 *
 * Deprecated: Use gimp_item_transform_2d() instead.
 *
 * Returns: The transformed drawable.
 **/
gint32
gimp_transform_2d (gint32   drawable_ID,
                   gboolean interpolation,
                   gdouble  source_x,
                   gdouble  source_y,
                   gdouble  scale_x,
                   gdouble  scale_y,
                   gdouble  angle,
                   gdouble  dest_x,
                   gdouble  dest_y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 ret_drawable_ID = -1;

  return_vals = gimp_run_procedure ("gimp-transform-2d",
                                    &nreturn_vals,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_INT32, interpolation,
                                    GIMP_PDB_FLOAT, source_x,
                                    GIMP_PDB_FLOAT, source_y,
                                    GIMP_PDB_FLOAT, scale_x,
                                    GIMP_PDB_FLOAT, scale_y,
                                    GIMP_PDB_FLOAT, angle,
                                    GIMP_PDB_FLOAT, dest_x,
                                    GIMP_PDB_FLOAT, dest_y,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    ret_drawable_ID = return_vals[1].data.d_drawable;

  gimp_destroy_params (return_vals, nreturn_vals);

  return ret_drawable_ID;
}
