// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//
//
//
// Description: Enumeration for possible values of AutomationProperties.HeadingLevel
//

namespace System.Windows.Automation
{
    /// <summary>
    /// Describes the heading level of a control
    /// </summary>
    public enum AutomationHeadingLevel
    {
        /// <summary>
        /// The element does not have a heading level
        /// </summary>
        None = 0,

        /// <summary>
        /// The element has a heading level of 1
        /// </summary>
        Level1,

        /// <summary>
        /// The element has a heading level of 2
        /// </summary>
        Level2,

        /// <summary>
        /// The element has a heading level of 3
        /// </summary>
        Level3,

        /// <summary>
        /// The element has a heading level of 4
        /// </summary>
        Level4,

        /// <summary>
        /// The element has a heading level of 5
        /// </summary>
        Level5,

        /// <summary>
        /// The element has a heading level of 6
        /// </summary>
        Level6,

        /// <summary>
        /// The element has a heading level of 7
        /// </summary>
        Level7,
 
        /// <summary>
        /// The element has a heading level of 8
        /// </summary>
        Level8,
 
        /// <summary>
        /// The element has a heading level of 9
        /// </summary>
        Level9,
    }

}