// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Generated by Fuzzlyn v2.2 on 2024-08-01 14:37:47
// Run on Arm64 MacOS
// Seed: 14773448547728333023-vectort,vector64,vector128,armadvsimd,armadvsimdarm64,armaes,armarmbase,armarmbasearm64,armcrc32,armcrc32arm64,armdp,armrdm,armrdmarm64,armsha1,armsha256
// Reduced from 270.2 KiB to 0.4 KiB in 00:01:48
// Debug: Outputs 0
// Release: Outputs 1
using System;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.Arm;
using Xunit;

public class Runtime_105817
{
    [Fact]
    public static void TestOverShiftLeftLogical()
    {
        if (AdvSimd.IsSupported)
        {
            var vr6 = Vector128.Create<short>(1);
            var vr7 = AdvSimd.ShiftLeftLogical(vr6, 16);
            Assert.Equal(vr7, Vector128<short>.Zero);
        }
    }

    [Fact]
    public static void TestOverShiftLeftLogicalScalar()
    {
        if (AdvSimd.IsSupported)
        {
            var vr6 = Vector64.Create<long>(1);
            var vr7 = AdvSimd.ShiftLeftLogicalScalar(vr6, 64);
            Assert.Equal(vr7, Vector64<long>.Zero);
        }
    }

    [Fact]
    public static void TestOverShiftRightLogical()
    {
        if (AdvSimd.IsSupported)
        {
            var vr6 = Vector128.Create<short>(1);
            var vr7 = AdvSimd.ShiftRightLogical(vr6, 16);
            Assert.Equal(vr7, Vector128<short>.Zero);
        }
    }

    [Fact]
    public static void TestOverShiftRightLogicalScalar()
    {
        if (AdvSimd.IsSupported)
        {
            var vr6 = Vector64.Create<long>(1);
            var vr7 = AdvSimd.ShiftRightLogicalScalar(vr6, 64);
            Assert.Equal(vr7, Vector64<long>.Zero);
        }
    }

    [Fact]
    public static void TestOverShiftRightArithmetic()
    {
        if (AdvSimd.IsSupported)
        {
            var vr6 = Vector128.Create<short>(1);
            var vr7 = AdvSimd.ShiftRightArithmetic(vr6, 16);
            Assert.Equal(vr7, Vector128<short>.Zero);
        }
    }

    [Fact]
    public static void TestOverShiftRightArithmeticScalar()
    {
        if (AdvSimd.IsSupported)
        {
            var vr6 = Vector64.Create<long>(1);
            var vr7 = AdvSimd.ShiftRightArithmeticScalar(vr6, 64);
            Assert.Equal(vr7, Vector64<long>.Zero);
        }
    }
}