/**
 * Copyright (C) 2018 Xilinx, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License"). You may
 * not use this file except in compliance with the License. A copy of the
 * License is located at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
#include "ocl_icd_bindings.h"
#include <CL/cl_ext_xilinx.h>

// Sanity check that the sizeof the struct doesn't change unexpectedly.
// Not possible since struct size is different depending on OS, but it
// doesn't matter all that's important is that entries that matter are
// populated, trailing 0s don't matter.
//static_assert(sizeof(_cl_icd_dispatch)==178*sizeof(void*),"Fix dispatch table");

const cl_icd_dispatch cl_icd_dispatch_obj = {
  clGetPlatformIDs,
  clGetPlatformInfo,
  clGetDeviceIDs,
  clGetDeviceInfo,
  clCreateContext,
  clCreateContextFromType,
  clRetainContext,
  clReleaseContext,
  clGetContextInfo,
  clCreateCommandQueue,
  clRetainCommandQueue,
  clReleaseCommandQueue,
  clGetCommandQueueInfo,
  clSetCommandQueueProperty,
  clCreateBuffer,
  clCreateImage2D,
  clCreateImage3D,
  clRetainMemObject,
  clReleaseMemObject,
  clGetSupportedImageFormats,
  clGetMemObjectInfo,
  clGetImageInfo,
  clCreateSampler,
  clRetainSampler,
  clReleaseSampler,
  clGetSamplerInfo,
  clCreateProgramWithSource,
  clCreateProgramWithBinary,
  clRetainProgram,
  clReleaseProgram,
  clBuildProgram,
  clUnloadCompiler,
  clGetProgramInfo,
  clGetProgramBuildInfo,
  clCreateKernel,
  clCreateKernelsInProgram,
  clRetainKernel,
  clReleaseKernel,
  clSetKernelArg,
  clGetKernelInfo,
  clGetKernelWorkGroupInfo,
  clWaitForEvents,
  clGetEventInfo,
  clRetainEvent,
  clReleaseEvent,
  clGetEventProfilingInfo,
  clFlush,
  clFinish,
  clEnqueueReadBuffer,
  clEnqueueWriteBuffer,
  clEnqueueCopyBuffer,
  clEnqueueReadImage,
  clEnqueueWriteImage,
  clEnqueueCopyImage,
  clEnqueueCopyImageToBuffer,
  clEnqueueCopyBufferToImage,
  clEnqueueMapBuffer,
  clEnqueueMapImage,
  clEnqueueUnmapMemObject,
  clEnqueueNDRangeKernel,
  clEnqueueTask,
  clEnqueueNativeKernel,
  clEnqueueMarker,
  clEnqueueWaitForEvents,
  clEnqueueBarrier,
  clGetExtensionFunctionAddress,
  0, //clCreateFromGLBuffer,
  0, //clCreateFromGLTexture2D,
  0, //clCreateFromGLTexture3D,
  0, //clCreateFromGLRenderbuffer,
  0, //clGetGLObjectInfo,
  0, //clGetGLTextureInfo,
  0, //clEnqueueAcquireGLObjects,
  0, //clEnqueueReleaseGLObjects,
  0, //clGetGLContextInfoKHR,
  0,
  0,
  0,
  0,
  0,
  0,
  clSetEventCallback,
  clCreateSubBuffer,
  clSetMemObjectDestructorCallback,
  clCreateUserEvent,
  clSetUserEventStatus,
  clEnqueueReadBufferRect,
  clEnqueueWriteBufferRect,
  clEnqueueCopyBufferRect,
  0, //aclCreateSubDevicesEXT,
  0, //clRetainDeviceEXT,
  0, //clReleaseDeviceEXT,
  0, //clCreateEventFromGLsyncKHR,
  clCreateSubDevices,
  clRetainDevice,
  clReleaseDevice,
  clCreateImage,
  clCreateProgramWithBuiltInKernels,
  clCompileProgram,
  clLinkProgram,
  clUnloadPlatformCompiler,
  clGetKernelArgInfo,
  clEnqueueFillBuffer,
  clEnqueueFillImage,
  clEnqueueMigrateMemObjects,
  clEnqueueMarkerWithWaitList,
  clEnqueueBarrierWithWaitList,
  clGetExtensionFunctionAddressForPlatform,
  0, //clCreateFromGLTexture,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0, //clCreateFromEGLImageKHR,
  0, //clEnqueueAcquireEGLObjectsKHR,
  0, //clEnqueueReleaseEGLObjectsKHR,
  0, //clCreateEventFromEGLSyncKHR,
  0, //clCreateCommandQueueWithProperties,
  clCreatePipe,
  clGetPipeInfo,
  clSVMAlloc,
  clSVMFree,
  0, //clEnqueueSVMFree,
  0, //clEnqueueSVMMemcpy,
  0, //clEnqueueSVMMemFill,
  clEnqueueSVMMap,
  clEnqueueSVMUnmap,
  0, //clCreateSamplerWithProperties,
  0, //clSetKernelArgSVMPointer,
  0, //clSetKernelExecInfo,
  0, //clGetKernelSubGroupInfoKHR,
  0, //clCloneKernel,
  0, //clCreateProgramWithIL,
  0, //clEnqueueSVMMigrateMem,
  0, //clGetDeviceAndHostTimer,
  0, //clGetHostTimer,
  0, //clGetKernelSubGroupInfo,
  0, //clSetDefaultDeviceCommandQueue,
  0, //clSetProgramReleaseCallback,
  0, //clSetProgramSpecializationConstant,
#ifndef _WIN32
#if (defined (__aarch64__) || defined (__arm__)) && defined (OPENCL_ICD_LOADER)
  0, //clCreateBufferWithProperties
  0, //clCreateImageWithProperties
  0, //clSetContextDestructorCallback
#else
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0
#endif
#endif
};
