target=spline2 splinelagrange2

#if #TARGET(spline2)
\title{Interpolation par spline cubique (II)}
#endif
#if #TARGET(splinelagrange2)
\title{Interpolation : Comparaison (II)}
#endif
\integer{n=4}
\author{Bernadette Perrin-Riou}
\email{bpr@math.u-psud.fr}
\precision{1000}
\text{style = <style type="text/css">
 .question {
  background-color: #FFFFAA;
  margin : 2% 5%;
  padding : 2%;
  text-align: left;}
  .reponse {background-color : #ffcc99;
          color : black;
          margin : 2% 5%;
          padding : 2%;}
 </style>}
 
 
\text{S = 0,randint(50..79),randint(101..200),randint(300..400)}
\text{S=pari(0.1*[\S])}
\real{t = \S[2]-\S[1]}
\real{u = \S[3]-\S[2]}
\real{v = \S[4]-\S[3]}

Approximation par splines :

\matrix{M = pari(M=matrix(12,12) ; 
M[1,4] =1 ; 
M[2,]  =[\t^3,\t^2,\t,1,0,0,0,0,0,0,0,0];
M[3,8] =1 ; 
M[4,]  =[0,0,0,0,\u^3,\u^2,\u,1,0,0,0,0];
M[5,12]=1 ; 
M[6,]  =[0,0,0,0,0,0,0,0,\v^3,\v^2,\v,1];
M[7,]  =[3*\t^2,2*\t,1,0,0,0,-1,0,0,0,0,0];
M[8,]  =[0,0,0,0,3*\u^2,2*\u,1,0,0,0,-1,0];
M[9,]  =[6*\t,2,0,0,0,-2,0,0,0,0,0,0];
M[10,] =[0,0,0,0,6*\u,2,0,0,0,-2,0,0];
M[11,] =[0,2,0,0,0,0,0,0,0,0,0,0];
M[12,] =[0,0,0,0,0,0,0,0,6*\v,2,0,0] ; M)}
\text{H = randint(4..20),randint(40..50),randint(70..90)}
text{H=30,60,90}
\text{V =0,\H[1],\H[1],\H[2],\H[2],\H[3],0,0,0,0,0,0}
\matrix{N = pari(floor(10000*[\M]^(-1)*[\V]~)~*0.0001)}
\text{f1= \N[1]*t^3 + \N[2]*t^2 + \N[3]*t +\N[4] }
\text{f2= \N[5]*(t-\S[2])^3 + (\N[6])*(t-\S[2])^2 + (\N[7])*(t-\S[2]) +(\N[8]) }
\text{f3= \N[9]*(t-\S[3])^3 + (\N[10])*(t-\S[3])^2 + (\N[11])*(t-\S[3]) +(\N[12])}
\text{f1x= simplify(\N[1]*x^3 + (\N[2])*x^2 + (\N[3])*x + (\N[4]))}
\text{f2x= simplify(\N[5]*(x-\S[2])^3 + (\N[6])*(x-\S[2])^2 + (\N[7])*(x-\S[2]) +(\N[8])) }
\text{f3x= simplify(\N[9]*(x-\S[3])^3 + (\N[10])*(x-\S[3])^2 + (\N[11])*(x-\S[3]) +(\N[12]))}


\text{P1 = a_1 * (x-\S[1])^3 + b_1 * (x-\S[1])^2 + c_1 * (x-\S[1]) + d_1}
\text{P2 = a_2 * (x-\S[2])^3 + b_2 * (x-\S[2])^2 + c_2 * (x-\S[2]) + d_2}
\text{P3 = a_3 * (x-\S[3])^3 + b_3 * (x-\S[3])^2 + c_3 * (x-\S[3]) + d_3}

\text{Mhtml=wims(rows2lines \M)}

#if #TARGET(splinelagrange2)
Approximation par lagrange
%%%%

text{P = a *x^3 + b *x^2 + c *x + d}
\matrix{Ml = pari(M=matrix(4,4) ; 
  M[1,] = [(\S[1])^3,(\S[1])^2,\S[1],1] ;
  M[2,] = [(\S[2])^3,(\S[2])^2,\S[2],1] ; 
  M[3,] = [(\S[3])^3,(\S[3])^2,\S[3],1] ; 
  M[4,] = [(\S[4])^3,(\S[4])^2,\S[4],1] ;
  M)}
\text{Vl =0,\H[1],\H[2],\H[3]}
\matrix{Nl = pari(floor(10000*[\Ml]^(-1)*[\Vl]~)~*0.0001)}
\text{fl= \Nl[1]*t^3 + \Nl[2]*t^2 + \Nl[3]*t +\Nl[4] }
#endif
%%%%
\text{Dessin=xrange -2,45
yrange -10,120
disk \S[1],0,7,green
disk \S[2],\H[1],7,green
disk \S[3],\H[2],7,green
disk \S[4],\H[3],7,green
dvline \S[2],0,red
dvline \S[3],0,red
dvline \S[4],0,red
hline 0,0,blue
trange \S[1],\S[2]
plot black,t,\f1
trange \S[2],\S[3]
plot blue,t,\f2
trange \S[3],\S[4]
plot green,t,\f3
}

\text{enonce=
Dans le tableau suivant, voici quelques valeurs donnant la vitesse
d'un vhicule en accleration en fonction du temps. }

#if #TARGET(spline2)

\text{Dessin=draw(200,200
\Dessin)}



\text{enonce2=
On dsire interpoler ces points par une fonction "lisse", par exemple, c'est--dire trouver 
une fonction \(f) donnant la vitesse en fonction du temps qui soit
continue et drivable deux fois. Pour cela, comme dans le cas de l'approximation linaire,
on va chercher sur chacun des segments [\S[1],\S[2]], [\S[2],\S[3]] et [\S[3],\S[4]]
une fonction cubique que l'on crit sous la forme 
\(P_1 = \P1) (resp. \(P_2 = \P2), \(P_3 = \P3)).  }

\steps{r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12
r13,r14,r15}

\statement{
\style \enonce
<table align="center" border=1>
   <tr><th>Temps</th><td align="center">\S[1]</td><td align="center">\S[2]</td><td align="center">\S[3]</td><td align="center">\S[4]</td></tr>
   <tr><th>Vitesse</th><td align="center">\V[1]</td><td align="center">\V[2]</td><td align="center">\V[3]</td><td align="center">\V[4]</td></tr>
 </table>

 \enonce2
 
 \if{\step=1}{
<div class="question">Ecrire les coefficients du
systme linaire que vrifient les coefficients \(a_1, b_1, c_1, d_1, 
a_2, b_2, c_2, d_2, a_3, b_3, c_3, d_3)
des trois polynmes cubiques \(P_1), \(P_2), \(P_3). </div>
<ol><li>
Condition au premier point : 
\embed{reply1}
</li>
<li>
Condition au deuxime point ( gauche) : 
\embed{reply2}
</li>
<li>
Condition au deuxime point ( droite) : 
\embed{reply3}
</li>
<li>
Condition au troisime point ( gauche) : 
\embed{reply4}
</li>
<li value=5>
Condition au  troisime point ( droite) : 
\embed{reply5}
</li>
<li value=6>
Condition au quatrime point ( gauche) : 
\embed{reply6}
</li>
</ol>

<ol><li value=7>
Drivabilit au deuxime point : 
\embed{reply7}
</li>
<li value=8>
Drivabilit au troisime point : 
\embed{reply8}
</li>
</ol>
<ol><li value=9>
Drivabilit seconde au deuxime point : 
\embed{reply9}
</li>
<li value=10>
Drivabilit seconde au troisime point : 
\embed{reply10}
</li>
</ol>

<ol><li value=11>
Drive seconde nulle au premier point : 
\embed{reply11}
</li>
<li value=12>
Drivabilit nulle au quatrime point : 
\embed{reply12}
</li>
</ol>

}
\if{\step=2}{La matrice du systme est en effet 
<pre>
\special{expandlines \Mhtml}
</pre>
<div class="question">Rsoudre le systme et donner les polynmes solution : 
</div><ul> 
<li>\embed{reply13} sur [\S[1],\S[2]]</li>
<li>\embed{reply14} sur [\S[2],\S[3]]</li>
<li>\embed{reply15} sur [\S[3],\S[4]]</li>
</ul>
</div>
}
<p align=center><img src=\Dessin></p>
}

\answer{}{\M[1;]}{type=vector}
\answer{}{\M[2;]}{type=vector}
\answer{}{\M[3;]}{type=vector}
\answer{}{\M[4;]}{type=vector}
\answer{}{\M[5;]}{type=vector}
\answer{}{\M[6;]}{type=vector}
\answer{}{\M[7;]}{type=vector}
\answer{}{\M[8;]}{type=vector}
\answer{}{\M[9;]}{type=vector}
\answer{}{\M[10;]}{type=vector}
\answer{}{\M[11;]}{type=vector}
\answer{}{\M[12;]}{type=vector}
\answer{}{\f1x,x}{type=function}
\answer{}{\f2x,x}{type=function}
\answer{}{\f3x,x}{type=function}

#endif

#if #TARGET(splinelagrange2)
  \real{S0= randitem(randint(10*\S[1]+10 .. 10*\S[2]-10) , 
  randint(10*\S[2]+10 .. 10*\S[3]-10),randint(10*\S[3]+10 .. 10*\S[4]-10))/10}
  \real{Vlag= evalue(\fl,t=\S0)}
  \real{Vspline= \S0 < \S[2] ? evalue(\f1,t=\S0):evalue(\f2,t=\S0)}
  \real{Vspline= \S0 > \S[3] ? evalue(\f3,t=\S0)}
 
 
 
\text{Dessin=draw(200,200
\Dessin
trange \S[1],\S[4]
plot purple,t,\fl
vline \S0,0,green)}


\statement{\style \enonce
<table align="center" border=1>
   <tr><th align="center">Temps</th><td align="center">\S[1]</td><td align="center">\S[2]</td>
   <td align="center">\S[3]</td><td align="center">\S[4]</td></tr>
   <tr><th align="center">Vitesse</th><td align="center">\V[1]</td>
   <td align="center">\V[2]</td><td align="center">\V[3]</td><td align="center">\V[4]</td></tr>
 </table>

 \enonce2
 
 Donner la vitesse en \(x = \S0) si l'on utilise une 
 <ul>
   <li>interpolation polynomiale de Lagrange : \embed{reply1} </li>
   <li>interpolation par des splines cubiques : \embed{reply2} </li>
 </ul>
 <i> Pour l'interpolation par des splines, on imposera la drive seconde nulle
aux extrmits.</i>
<p align="center"><img src=\Dessin></p>
}
\answer{}{\Vlag}{type=numeric}
\answer{}{\Vspline}{type=numeric}
#endif



