require 'spec_helper'

describe Vim::AddonManager::Addon::Directory do

  it 'report status as :not_installed by default' do
    addon('newstyle').status(target_dir).status.should == :not_installed
  end

  it 'lists files inside the directory' do
    addon = addon('newstyle')
    addon.stub(:basedir).and_return(File.join(FAKE_SCRIPTS))
    addon.files.should include('vam/newstyle/ftplugin/newstyle.vim')
    addon.files.should include('vam/newstyle/syntax/newstyle.vim')
  end

  it 'constructs source with basedir by default' do
    addon = addon('newstyle')
    addon.stub(:basedir).and_return('/base/dir')
    addon.directory.should be_nil
    addon.send(:source).should == '/base/dir/vam/newstyle'
  end

  it 'uses directory as source if specified' do
    addon = addon('newstylewithdir')
    addon.directory.should == '/path/to/newstylewithdir'
    addon.send(:source).should == '/path/to/newstylewithdir'
  end

  context 'when installed' do
    before do
      @addon = addon('newstyle')
      @addon.install(target_dir)
    end

    it 'installs symlink into ~/.vim/vam/' do
      Dir.glob(File.join(target_dir.path, 'vam', 'newstyle')).should_not be_empty
    end

    it 'points to the source directory' do
      File.readlink(File.join(target_dir.path, 'vam', 'newstyle')).should == @addon.send(:source)
    end

    it 'reports status as :installed' do
      @addon.status(target_dir).status.should == :installed
    end

    context 'and removed' do

      before do
        @addon.remove(target_dir)
      end

      it 'reports status as :not_installed' do
        @addon.status(target_dir.path).status.should == :not_installed
      end

      it 'removes symlink from ~/.vim/vam/' do
        Dir.glob(File.join(target_dir.path, 'vam', 'newstyle')).should be_empty
      end

    end
  end

end
