/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_GNOME
 #if ENABLE_NLS
   #include <libintl.h>
//#define _(str) gettext(str)
   #define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
    #define N_(str) str
 #else
   #define _(str) str
   #define N_(str) str 
  #endif
#endif

#include <vdkb2/vdkb_dlgs.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_evcontain.h>
#include <vdkb2/vdkb_types.h>
static char buff[128];

DEFINE_SIGNAL_MAP(VDKBPropSizeDialog,VDKBPropDialog)
  ON_SIGNAL(hspin,value_changed_signal,OnChange),
  ON_SIGNAL(vspin,value_changed_signal,OnChange),
  ON_SIGNAL(reset,clicked_signal,OnReset)
END_SIGNAL_MAP
/*
  FIX ME:
  change VDK  to have spin ValueAsFloat as read/write property.
 */
bool
VDKBPropSizeDialog::OnChange(VDKObject* sender)
{
  sprintf(buff,"%d,%d",(int) hspin->ValueAsInt, (int) vspin->ValueAsInt);
  active->SetPropValue(USIZE,buff);
  active->ObjectFromVDK()->SetSize(hspin->ValueAsInt,vspin->ValueAsInt);
  return true;
}

/*
 */
bool
VDKBPropSizeDialog::OnReset(VDKObject* sender)
{
  active->SetPropValue(USIZE,"nihil");
  active->ObjectFromVDK()->SetSize(-1,-1);
  return true;
}
/*
 */
void
VDKBPropSizeDialog::Setup()
{
  VDKTable *table = new VDKTable(this,3,2);
  table->SetSize(180,80);
  if(active)
    {
      VDKPoint p =  active->ObjectFromVDK()->Usize;
      table->AddToCell(new VDKLabel(this,_("Horizontal size")),0,0);
      table->AddToCell(hspin = new VDKSpinButton(this, p.X(), 0,1024,1,0),0,1);
      table->AddToCell(new VDKLabel(this,_("Vertical size")),1,0);
      table->AddToCell(vspin = new VDKSpinButton(this, p.Y(), 0,768,1,0),1,1);
      table->AddToCell(reset = new VDKCustomButton(this,_("_Reset to min size")),2,0);
    }
  Add(table);
  // set initial position
  gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_MOUSE);
}



