/***************************************************************************
     dcfilelistdecompressor.h  -  Valknut Filelist Processing Thread
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILELISTDECOMPRESSOR_H
#define DCFILELISTDECOMPRESSOR_H

/**
 * @author Edward Sheldrake
 *
 * This is a QThread that processes a filelist and emits a signal when finished
 * which the DCFileBrowser will respond to.
 *
 * Currently it only does the bzip2/he3 decompression, and for old valknut
 * filelists, removes the header and compresses to bzip2.
 *
 * After DCFileBrowser is ported to QT4 properly using the Model/View
 * architecture, it will also do the text / xml parsing and
 * create the model.
 */

#include <QObject>
#include <QThread>

#include <dclib/core/cstring.h>

class CByteArray;

class DCFilelistDecompressor : public QThread {
Q_OBJECT

public:
	/** constructor for decompressing a list from disk */
	DCFilelistDecompressor( QObject * parent, CString filename );
	/** constructor for decompressing our own list from memory */
	DCFilelistDecompressor( QObject * parent, CByteArray * memory );
	/** destructor */
	virtual ~DCFilelistDecompressor();
	
	/** the method that runs in the thread */
	virtual void run();
	
	/** returns the pointer to the decompressed data */
	CString * getData();
	/** */
	CByteArray * recompressed;

signals:
	/** */
	virtual void finished( bool ok );

private:
	/** */
	bool LoadOldValknutList( CByteArray * dest );
	/** file name */
	CString filename;
	/** decompress from memory */
	CByteArray * compressed;
	/** pointer to the decompressed data */
	CString * data;
};

#endif // DCFILELISTDECOMPRESSOR_H
