package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPhysicalConnectionServiceStatus invokes the vpc.GetPhysicalConnectionServiceStatus API synchronously
func (client *Client) GetPhysicalConnectionServiceStatus(request *GetPhysicalConnectionServiceStatusRequest) (response *GetPhysicalConnectionServiceStatusResponse, err error) {
	response = CreateGetPhysicalConnectionServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetPhysicalConnectionServiceStatusWithChan invokes the vpc.GetPhysicalConnectionServiceStatus API asynchronously
func (client *Client) GetPhysicalConnectionServiceStatusWithChan(request *GetPhysicalConnectionServiceStatusRequest) (<-chan *GetPhysicalConnectionServiceStatusResponse, <-chan error) {
	responseChan := make(chan *GetPhysicalConnectionServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPhysicalConnectionServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPhysicalConnectionServiceStatusWithCallback invokes the vpc.GetPhysicalConnectionServiceStatus API asynchronously
func (client *Client) GetPhysicalConnectionServiceStatusWithCallback(request *GetPhysicalConnectionServiceStatusRequest, callback func(response *GetPhysicalConnectionServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPhysicalConnectionServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetPhysicalConnectionServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPhysicalConnectionServiceStatusRequest is the request struct for api GetPhysicalConnectionServiceStatus
type GetPhysicalConnectionServiceStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetPhysicalConnectionServiceStatusResponse is the response struct for api GetPhysicalConnectionServiceStatus
type GetPhysicalConnectionServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Enabled   bool   `json:"Enabled" xml:"Enabled"`
}

// CreateGetPhysicalConnectionServiceStatusRequest creates a request to invoke GetPhysicalConnectionServiceStatus API
func CreateGetPhysicalConnectionServiceStatusRequest() (request *GetPhysicalConnectionServiceStatusRequest) {
	request = &GetPhysicalConnectionServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetPhysicalConnectionServiceStatus", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPhysicalConnectionServiceStatusResponse creates a response to parse from GetPhysicalConnectionServiceStatus response
func CreateGetPhysicalConnectionServiceStatusResponse() (response *GetPhysicalConnectionServiceStatusResponse) {
	response = &GetPhysicalConnectionServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
