package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCACertificates invokes the slb.DescribeCACertificates API synchronously
func (client *Client) DescribeCACertificates(request *DescribeCACertificatesRequest) (response *DescribeCACertificatesResponse, err error) {
	response = CreateDescribeCACertificatesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCACertificatesWithChan invokes the slb.DescribeCACertificates API asynchronously
func (client *Client) DescribeCACertificatesWithChan(request *DescribeCACertificatesRequest) (<-chan *DescribeCACertificatesResponse, <-chan error) {
	responseChan := make(chan *DescribeCACertificatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCACertificates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCACertificatesWithCallback invokes the slb.DescribeCACertificates API asynchronously
func (client *Client) DescribeCACertificatesWithCallback(request *DescribeCACertificatesRequest, callback func(response *DescribeCACertificatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCACertificatesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCACertificates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCACertificatesRequest is the request struct for api DescribeCACertificates
type DescribeCACertificatesRequest struct {
	*requests.RpcRequest
	AccessKeyId          string                       `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string                       `position:"Query" name:"ResourceGroupId"`
	Tag                  *[]DescribeCACertificatesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                       `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                       `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer             `position:"Query" name:"OwnerId"`
	CACertificateId      string                       `position:"Query" name:"CACertificateId"`
}

// DescribeCACertificatesTag is a repeated param struct in DescribeCACertificatesRequest
type DescribeCACertificatesTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeCACertificatesResponse is the response struct for api DescribeCACertificates
type DescribeCACertificatesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	CACertificates CACertificates `json:"CACertificates" xml:"CACertificates"`
}

// CreateDescribeCACertificatesRequest creates a request to invoke DescribeCACertificates API
func CreateDescribeCACertificatesRequest() (request *DescribeCACertificatesRequest) {
	request = &DescribeCACertificatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DescribeCACertificates", "Slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCACertificatesResponse creates a response to parse from DescribeCACertificates response
func CreateDescribeCACertificatesResponse() (response *DescribeCACertificatesResponse) {
	response = &DescribeCACertificatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
