/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// test
#include "CommandArgsTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "util/CommandArgs.h"
#include "util/apr.h"


void CommandArgsTest::setUp()
{
}

void CommandArgsTest::tearDown()
{
}

void CommandArgsTest::testDiff()
{
  apr::Pool pool;

  CommandArgs args( 
    sc::String("path/diffcmd diff -d -L {baselabel} -L {minelabel} {base} {mine}"), pool );

  args.setArg( sc::String("{base}"), sc::String("BASE") );
  args.setArg( sc::String("{mine}"), sc::String("MINE") );
  args.setArg( sc::String("{baselabel}"), sc::String("BASELABEL") );
  args.setArg( sc::String("{minelabel}"), sc::String("MINELABEL") );

  const char*  cmdPath = args.getPath();
  char**       cmdArgs = args.getArgs();

  CPPUNIT_ASSERT_EQUAL( sc::String("."), sc::String(cmdPath) );

  CPPUNIT_ASSERT_EQUAL( sc::String("path/diffcmd"), sc::String(cmdArgs[0]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("diff"),         sc::String(cmdArgs[1]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("-d"),           sc::String(cmdArgs[2]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("-L"),           sc::String(cmdArgs[3]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("BASELABEL"),    sc::String(cmdArgs[4]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("-L"),           sc::String(cmdArgs[5]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("MINELABEL"),    sc::String(cmdArgs[6]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("BASE"),         sc::String(cmdArgs[7]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("MINE"),         sc::String(cmdArgs[8]) );
}

void CommandArgsTest::testMerge()
{
  apr::Pool pool;

  CommandArgs args( 
    sc::String("path/mergecmd merge -d {theirs} {mine} {base} {merged}"), pool );

  args.setArg( sc::String("{base}"), sc::String("BASE") );
  args.setArg( sc::String("{mine}"), sc::String("MINE") );
  args.setArg( sc::String("{theirs}"), sc::String("THEIRS") );
  args.setArg( sc::String("{merged}"), sc::String("MERGED") );

  const char*  cmdPath = args.getPath();
  char**       cmdArgs = args.getArgs();

  CPPUNIT_ASSERT_EQUAL( sc::String(cmdPath), sc::String(".") );

  CPPUNIT_ASSERT_EQUAL( sc::String("path/mergecmd"), sc::String(cmdArgs[0]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("merge"),         sc::String(cmdArgs[1]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("-d"),            sc::String(cmdArgs[2]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("THEIRS"),        sc::String(cmdArgs[3]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("MINE"),          sc::String(cmdArgs[4]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("BASE"),          sc::String(cmdArgs[5]) );
  CPPUNIT_ASSERT_EQUAL( sc::String("MERGED"),        sc::String(cmdArgs[6]) );
}
