/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_ERROR_H
#define _SVN_ERROR_H

// sc
struct svn_error_t;
namespace sc {
  class Error;
}

namespace svn
{

/**
 * extract the svn_error_t* from the given \b err and delete \b err.
 * \param err the source Error object.
 * \return the wrapped svn_error_t*.
 */
svn_error_t* unwrapError( sc::Error* err );

/**
 * wrap an svn_error_t* in an Error object. The new object takes the
 * ownership of \b err.
 * \param err the svn_error_t*.
 * \return the wrapper Error object.
 */
sc::Error* wrapError( svn_error_t* err );


/**
 * helper macro
 */
#define SC_SVN_ERR(exp)\
{\
  svn_error_t* err = (exp);\
  if( err )\
  {\
    return svn::wrapError(err);\
  }\
}

} // namespace

#endif // _SVN_ERROR_H
