/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_IGNOREPARAM_H
#define _SC_IGNOREPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "util/String.h"


/**
 * Parameter class for IgnoreCmd.
 */
class IgnoreParam : public ScParam
{
public:
  IgnoreParam( const svn::Paths& paths ) : _paths(paths)
  {
  }

  const svn::Paths& getPaths() const
  {
    return _paths;
  }

  ScParamAccept(IgnoreParam);

private:
  // in
  svn::Paths _paths;
};

#endif // _SC_IGNOREPARAM_H
