/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "WcViewTreeItemModelTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "WcViewItemTest.h"
#include "subcommander/WcViewTreeItemModel.h"
#include "util/String.h"


void WcViewTreeItemModelTest::setUp()
{
  _model = new WcViewTreeItemModel( sc::String("invisible/root"), new WcViewItemDataTest() );

  connect(
    _model, SIGNAL(dataChanged(const QModelIndex&,const QModelIndex&)),
    this,   SLOT(  dataChanged(const QModelIndex&,const QModelIndex&)));
  connect(
    _model, SIGNAL(rowsAboutToBeInserted(const QModelIndex&,int,int)),
    this,   SLOT(  rowsAboutToBeInserted(const QModelIndex&,int,int)));
  connect(
    _model, SIGNAL(rowsInserted(const QModelIndex&,int,int)),
    this,   SLOT(  rowsInserted(const QModelIndex&,int,int)));

  _items[0].push_back( WcViewItemPtr(new WcViewItemTest(sc::String("invisible/root"),true,false)) );
  _items[0].push_back( WcViewItemPtr(new WcViewItemTest(sc::String("invisible/root/child"),true,false)) );

  _dataChanged[0].topLeft  = QModelIndex();
  _dataChanged[0].botRight = QModelIndex();

  _rowsInserted[0].parent = QModelIndex();
  _rowsInserted[0].start  = 0;
  _rowsInserted[0].end    = 0;

  _rowsInserted[1].parent = QModelIndex(); // set later
  _rowsInserted[1].start  = 0;
  _rowsInserted[1].end    = 0;
}

void WcViewTreeItemModelTest::tearDown()
{
  delete _model;
}

void WcViewTreeItemModelTest::add()
{
  _model->insert( sc::String("invisible/root"), _items[0] );
}

void WcViewTreeItemModelTest::dataChanged( const QModelIndex& topLeft, const QModelIndex& bottomRight )
{
  static int calls = -1; calls++;

  CPPUNIT_ASSERT( _dataChanged[calls].topLeft  == topLeft );  
  CPPUNIT_ASSERT( _dataChanged[calls].botRight == bottomRight );  
}

void WcViewTreeItemModelTest::rowsAboutToBeInserted( const QModelIndex& parent, int start, int end )
{
  static int calls = -1; calls++;

  CPPUNIT_ASSERT( _rowsInserted[calls].parent == parent );  
  CPPUNIT_ASSERT_EQUAL( _rowsInserted[calls].start, start );
  CPPUNIT_ASSERT_EQUAL( _rowsInserted[calls].end, end );
}

void WcViewTreeItemModelTest::rowsInserted( const QModelIndex& parent, int start, int end )
{
  static int calls = -1; calls++;

  CPPUNIT_ASSERT( _rowsInserted[calls].parent == parent );  
  CPPUNIT_ASSERT_EQUAL( _rowsInserted[calls].start, start );
  CPPUNIT_ASSERT_EQUAL( _rowsInserted[calls].end, end );

  _rowsInserted[calls+1].parent = _model->index(start,0,parent);
}
