/* Public domain. */

#ifndef IOBUFFER_H
#define IOBUFFER_H

#include "buffer.h"

typedef struct iobuffer iobuffer, *iobuffer_ref ;
struct iobuffer
{
  buffer in ;
  buffer out ;
} ;

#define IOBUFFER_INIT(fdin, fdout, buf, len) {BUFFER_INIT(&buffer_unixread, (fdin), (buf), (len)), BUFFER_INIT(&buffer_unixwrite, (fdout), (buf), (len))}
extern void iobuffer_init (iobuffer_ref, int, int, char *, unsigned int) ;
extern int iobuffer_fill (iobuffer_ref) ;
extern int iobuffer_flush (iobuffer_ref) ;
#define iobuffer_len(b) buffer_len(&(b)->in)
#define iobuffer_isempty(b) buffer_isempty(&(b)->in)
#define iobuffer_available(b) buffer_available(&(b)->out)
#define iobuffer_isfull(b) buffer_isfull(&(b)->out)

#endif
