/* Public domain. */

#include "avlnode.h"
#include "avlnodebunch.h"
#include "avltree.h"

static unsigned int avlnode_rotate_r (avlnode_ref s, unsigned int i)
{
  register unsigned int j = s[i].left ;
  s[i].left = s[j].right ;
  s[j].right = i ;
  if (s[j].balance < 0) s[i].balance = s[j].balance = 0 ;
  else s[j].balance = 1 ;
  return j ;
}

static unsigned int avlnode_rotate_l (avlnode_ref s, unsigned int i)
{
  register unsigned int j = s[i].right ;
  s[i].right = s[j].left ;
  s[j].left = i ;
  if (s[j].balance > 0) s[i].balance = s[j].balance = 0 ;
  else s[j].balance = -1 ;
  return j ;
}

static unsigned int avlnode_rotate_lr (avlnode_ref s, unsigned int i)
{
  register unsigned int j = s[i].left ;
  register unsigned int k = s[j].right ;
  s[i].left = s[k].right ;
  s[j].right = s[k].left ;
  s[k].left = j ;
  s[k].right = i ;
  s[i].balance = (s[k].balance < 0) ? 1 : 0 ;
  s[j].balance = (s[k].balance > 0) ? -1 : 0 ;
  s[k].balance = 0 ;
  return k ;
}

static unsigned int avlnode_rotate_rl (avlnode_ref s, unsigned int i)
{
  register unsigned int j = s[i].right ;
  register unsigned int k = s[j].left ;
  s[i].right = s[k].left ;
  s[j].left = s[k].right ;
  s[k].right = j ;
  s[k].left = i ;
  s[i].balance = (s[k].balance > 0) ? -1 : 0 ;
  s[j].balance = (s[k].balance < 0) ? 1 : 0 ;
  s[k].balance = 0 ;
  return k ;
}


#define MAXDEPTH 256   /* should be more than enough */

unsigned int avltree_insert (avltree_ref t, unsigned int k)
{
  unsigned int i = avlnodebunch_new(&t->x) ;
  if (!i--) return 0 ;
  {
    unsigned int stack[MAXDEPTH] ;
    signed char spin[MAXDEPTH] ;
    unsigned char done = 0 ;
    register unsigned int r = avltree_root(t) ;
    register unsigned int sp = 0 ;
    register avlnode_ref s = t->x.x.s ;
    s[i].data = k ;
    s[i].left = s[i].right = 0 ;
    s[i].balance = 0 ;
    while (r)
    {
      stack[sp] = r ;
      if ((*t->cmp)(k, s[r].data) <= 0)
      {
        spin[sp] = -1 ;
        r = s[r].left ;
      }
      else
      {
        spin[sp] = 1 ;
        r = s[r].right ;
      }
      sp++ ;
    }
    r = i ;
    while (sp--)
    {
      if (spin[sp] < 0) s[stack[sp]].left = r ; else s[stack[sp]].right = r ;
      if (done) return i ;
      switch (spin[sp] * s[stack[sp]].balance)
      {
        case -1 :
          s[stack[sp]].balance = 0 ;
          return i ;
        case 0 :
          s[stack[sp]].balance = spin[sp] ;
          r = stack[sp] ;
          break ;
        case 1 :
        {
          r = (spin[sp] < 0) ? (s[r].balance < 0) ?
            avlnode_rotate_r(s, stack[sp]) : avlnode_rotate_lr(s, stack[sp]) :
            (s[r].balance < 0) ?
            avlnode_rotate_rl(s, stack[sp]) : avlnode_rotate_l(s, stack[sp]) ;
          done = 1 ;
          break ;
        }
      }
    }
    avltree_setroot(t, r) ;
  }
  return i ;
}

unsigned int avltree_delete (avltree_ref t, unsigned int k)
{
  unsigned int stack[MAXDEPTH] ;
  signed char spin[MAXDEPTH] ;
  register unsigned int r = avltree_root(t) ;
  register unsigned int sp = 0 ;
  register avlnode_ref s = t->x.x.s ;
  unsigned char done = 0 ;
  for (;;)
  {
    register int h ;
    if (!r) return 0 ;
    h = (*t->cmp)(k, s[r].data) ;
    if (!h) break ;
    stack[sp] = r ;
    if (h < 0)
    {
      spin[sp] = -1 ;
      r = s[r].left ;
    }
    else
    {
      spin[sp] = 1 ;
      r = s[r].right ;
    }
    sp++ ;
  }
  k = r ;
  if (s[r].left)
  {
    stack[sp] = r ;
    spin[sp++] = -1 ;
    r = s[r].left ;
  }
  while (r)
  {
    stack[sp] = r ;
    spin[sp++] = 1 ;
    r = s[r].right ;
  }
  r = stack[--sp] ;
  s[k].data = s[r].data ;
  k = r ;
  r = s[r].left ;
  avlnodebunch_delete(&t->x, k+1) ;
  while (sp--)
  {
    if (spin[sp] < 0) s[stack[sp]].left = r ; else s[stack[sp]].right = r ;
    if (done) return 1 ;
    switch (spin[sp] * s[stack[sp]].balance)
    {
      case 0 :
        s[stack[sp]].balance = -spin[sp] ;
        return 1 ;
      case 1 :
        s[stack[sp]].balance = 0 ;
        r = stack[sp] ;
        break ;
      case -1 :
      {
        switch ((spin[sp] < 0) ? -s[s[stack[sp]].right].balance : s[s[stack[sp]].left].balance)
        {
          case 0 :
            done = 1 ;
          case -1 :
            r = (spin[sp] < 0) ? avlnode_rotate_l(s, stack[sp]) : avlnode_rotate_r(s, stack[sp]) ;
            break ;
          case 1 :
            r = (spin[sp] < 0) ? avlnode_rotate_rl(s, stack[sp]) : avlnode_rotate_lr(s, stack[sp]) ;
            break ;
        }
      }
    }
  }
  avltree_setroot(t, r) ;
  return k ;
}

unsigned int avltree_deletenode (avltree_ref t, unsigned int i)
{
  return avltree_delete(t, avltree_i(t, i)) ;
}
