/* Public domain. */

#include "avlnode.h"
#include "avltree.h"

static unsigned int avltree_height_rec (avlnode const *s, register unsigned int r)
{
  if (!r) return 0 ;
  if (s[r].balance) return 1 + avltree_height_rec(s, (s[r].balance < 0) ? s[r].left : s[r].right) ;
  {
    unsigned int h1 = avltree_height_rec(s, s[r].left) ;
    register unsigned int h2 = avltree_height_rec(s, s[r].right) ;
    return 1 + ((h1 > h2) ? h1 : h2) ;
  }
}

unsigned int avltree_height (avltree const *t)
{
  return avltree_height_rec (t->x.x.s, avltree_root(t)) ;
}
