% *************************************************************************
%  File:         PRO.fst
%  Author:       Helmut Schmid; IMS, University of Stuttgart
%  Date:         April 2003
%  Content:      pronouns, determiners -- 
% 	 converted to S-FST from stems.PRO
%**************************************************************************

% Lower-Case Pronouns

$Pro_Low$ = \
% Articles
da:es			<+ART><Def><Neut><Gen><Sg> |\
da:es:m			<+ART><Def><Neut><Dat><Sg> |\
das			<+ART><Def><Neut><Akk><Sg> |\
das			<+ART><Def><Neut><Nom><Sg> |\
der			<+ART><Def><Masc><Nom><Sg> |\
der:m			<+ART><Def><Masc><Dat><Sg> |\
der:n			<+ART><Def><Masc><Akk><Sg> |\
der:s			<+ART><Def><Masc><Gen><Sg> |\
di:<>e<>:n		<+ART><Def><NoGend><Dat><Pl> |\
di:<>e<>:r		<+ART><Def><Fem><Dat><Sg> |\
di:<>e<>:r		<+ART><Def><Fem><Gen><Sg> |\
di:<>e<>:r		<+ART><Def><NoGend><Gen><Pl> |\
die			<+ART><Def><Fem><Akk><Sg> |\
die			<+ART><Def><Fem><Nom><Sg> |\
die			<+ART><Def><NoGend><Akk><Pl> |\
die			<+ART><Def><NoGend><Nom><Pl> |\
ein			<+ART><Indef><Masc><Nom><Sg> |\
ein			<+ART><Indef><Neut><Akk><Sg> |\
ein			<+ART><Indef><Neut><Nom><Sg> |\
ein<>:e			<+ART><Indef><Fem><Akk><Sg> |\
ein<>:e			<+ART><Indef><Fem><Nom><Sg> |\
ein<>:e<>:m		<+ART><Indef><Masc><Dat><Sg> |\
ein<>:e<>:m		<+ART><Indef><Neut><Dat><Sg> |\
ein<>:e<>:n		<+ART><Indef><Masc><Akk><Sg> |\
ein<>:e<>:r		<+ART><Indef><Fem><Dat><Sg> |\
ein<>:e<>:r		<+ART><Indef><Fem><Gen><Sg> |\
ein<>:e<>:s		<+ART><Indef><Masc><Gen><Sg> |\
ein<>:e<>:s		<+ART><Indef><Neut><Gen><Sg> |\
% Personal Pronouns
du			<+PPRO><pers><2><Sg><NoGend><Nom> |\
du:e<>:i<>:n<>:e<>:r	<+PPRO><pers><2><Sg><NoGend><Gen> |\
du:i<>:c<>:h		<+PPRO><prfl><2><Sg><NoGend><Akk> |\
du:i<>:r		<+PPRO><prfl><2><Sg><NoGend><Dat> |\
e:ir:h<>:m		<+PPRO><pers><3><Sg><Masc><Dat> |\
e:ir:h<>:n		<+PPRO><pers><3><Sg><Masc><Akk> |\
e:is:h<>:m		<+PPRO><pers><3><Sg><Neut><Dat> |\
e:s<>:e<>:i<>:n<>:er	<+PPRO><pers><3><Sg><Masc><Gen> |\
e:sr:i<>:c<>:h		<+PPRO><refl><3><Sg><Masc> |\
e:ss:e<>:i<>:n<>:e<>:r	<+PPRO><pers><3><Sg><Neut><Gen> |\
e:ss:i<>:c<>:h		<+PPRO><refl><3><Sg><Neut> |\
einander		<+PPRO><rez> |\
er			<+PPRO><pers><3><Sg><Masc><Nom> |\
es			<+PPRO><pers><3><Sg><Neut><Akk> |\
es			<+PPRO><pers><3><Sg><Neut><Nom> |\
i:e<>:u<>:chr:<>	 <+PPRO><pers><2><Pl><NoGend><Akk> |\
i:e<>:u<>:chr:<>	 <+PPRO><pers><2><Pl><NoGend><Dat> |\
i:eh:u<>:er		<+PPRO><pers><2><Pl><NoGend><Gen> |\
i:m<>:ich		<+PPRO><prfl><1><Sg><NoGend><Akk> |\
i:mc:eh:i<>:n<>:e<>:r	<+PPRO><pers><1><Sg><NoGend><Gen> |\
i:mc:ih:r		<+PPRO><prfl><1><Sg><NoGend><Dat> |\
ich			<+PPRO><pers><1><Sg><NoGend><Nom> |\
ihr			<+PPRO><pers><2><Pl><NoGend><Nom> |\
s:ii:h<>:ne<>:n		<+PPRO><pers><3><Pl><NoGend><Dat> |\
s:ii:h<>:re<>:r		<+PPRO><pers><3><Pl><NoGend><Gen> |\
s:ii:h<>:re<>:r		<+PPRO><pers><3><Sg><Fem><Gen> |\
s:ii:he:r		<+PPRO><pers><3><Sg><Fem><Dat> |\
sie			<+PPRO><pers><3><Pl><NoGend><Akk> |\
sie			<+PPRO><pers><3><Pl><NoGend><Nom> |\
sie			<+PPRO><pers><3><Sg><Fem><Akk> |\
sie			<+PPRO><pers><3><Sg><Fem><Nom> |\
sie:c<>:h		<+PPRO><refl><3><Pl><NoGend> |\
sie:c<>:h		<+PPRO><refl><3><Sg><Fem> |\
w:u<>:n<>:si:er		<+PPRO><pers><1><Pl><NoGend><Gen> |\
w:ui:nr:s		<+PPRO><prfl><1><Pl><NoGend><Akk> |\
w:ui:nr:s		<+PPRO><prfl><1><Pl><NoGend><Dat> |\
wir			<+PPRO><pers><1><Pl><NoGend><Nom> |\
% Relative Pronouns
da:es:m			<+REL><subst><Neut><Dat><Sg> |\
da:es<>:s<>:e<>:n	<+REL><attr><Neut><Gen><Sg> |\
da:es<>:s<>:e<>:n	<+REL><subst><Neut><Gen><Sg> |\
das			<+REL><subst><Neut><Akk><Sg> |\
das			<+REL><subst><Neut><Nom><Sg> |\
der			<+REL><subst><Masc><Nom><Sg> |\
der:m			<+REL><subst><Masc><Dat><Sg> |\
der:n			<+REL><subst><Masc><Akk><Sg> |\
der:s<>:s<>:e<>:n	<+REL><attr><Masc><Gen><Sg> |\
der:s<>:s<>:e<>:n	<+REL><subst><Masc><Gen><Sg> |\
di:<>e<>:r		<+REL><subst><Fem><Dat><Sg> |\
di:e<>:ne<>:n		<+REL><subst><NoGend><Dat><Pl> |\
di:e<>:re<>:n		<+REL><attr><Fem><Gen><Sg> |\
di:e<>:re<>:n		<+REL><attr><NoGend><Gen><Pl> |\
di:e<>:re<>:n		<+REL><subst><Fem><Gen><Sg> |\
di:e<>:re<>:r		<+REL><subst><NoGend><Gen><Pl> |\
die			<+REL><subst><Fem><Akk><Sg> |\
die			<+REL><subst><Fem><Nom><Sg> |\
die			<+REL><subst><NoGend><Akk><Pl> |\
die			<+REL><subst><NoGend><Nom><Pl> |\
was			<+REL><subst><Neut><Akk><Sg> |\
was			<+REL><subst><Neut><Nom><Sg> |\
welche			<+REL><subst><Fem><Akk><Sg> |\
welche			<+REL><subst><Fem><Nom><Sg> |\
welche			<+REL><subst><NoGend><Akk><Pl> |\
welche			<+REL><subst><NoGend><Nom><Pl> |\
welche<>:n		<+REL><subst><NoGend><Dat><Pl> |\
welche<>:r		<+REL><subst><Fem><Dat><Sg> |\
welcher			<+REL><subst><Masc><Nom><Sg> |\
welcher:m		<+REL><subst><Masc><Dat><Sg> |\
welcher:n		<+REL><subst><Masc><Akk><Sg> |\
welches			<+REL><subst><Neut><Akk><Sg> |\
welches			<+REL><subst><Neut><Nom><Sg> |\
welches:m		<+REL><subst><Neut><Dat><Sg> |\
% Demostrative Pronouns
da:es			<+DEM><subst><Neut><Gen><Sg> |\
da:es:m			<+DEM><subst><Neut><Dat><Sg> |\
da:es:mjenige<>:n	<+DEM><pro><Neut><Dat><Sg> |\
da:es:mselbe<>:n	<+DEM><pro><Neut><Dat><Sg> |\
da:es<>:s<>:e<>:n	<+DEM><subst><Neut><Gen><Sg> |\
da:esjenige<>:n		<+DEM><pro><Neut><Gen><Sg> |\
da:esselbe<>:n		<+DEM><pro><Neut><Gen><Sg> |\
das			<+DEM><subst><Neut><Akk><Sg> |\
das			<+DEM><subst><Neut><Nom><Sg> |\
dasjenige		<+DEM><pro><Neut><Akk><Sg> |\
dasjenige		<+DEM><pro><Neut><Nom><Sg> |\
dasselbe		<+DEM><pro><Neut><Akk><Sg> |\
dasselbe		<+DEM><pro><Neut><Nom><Sg> |\
der			<+DEM><subst><Masc><Nom><Sg> |\
der:m			<+DEM><subst><Masc><Dat><Sg> |\
der:mjenige<>:n		<+DEM><pro><Masc><Dat><Sg> |\
der:mselbe<>:n		<+DEM><pro><Masc><Dat><Sg> |\
der:n			<+DEM><subst><Masc><Akk><Sg> |\
der:njenige<>:n		<+DEM><pro><Masc><Akk><Sg> |\
der:nselbe<>:n		<+DEM><pro><Masc><Akk><Sg> |\
der:s			<+DEM><subst><Masc><Gen><Sg> |\
der:s<>:s<>:e<>:n	<+DEM><subst><Masc><Gen><Sg> |\
der:sjenige<>:n		<+DEM><pro><Masc><Gen><Sg> |\
der:sselbe<>:n		<+DEM><pro><Masc><Gen><Sg> |\
derjenige		<+DEM><pro><Masc><Nom><Sg> |\
derselbe		<+DEM><pro><Masc><Nom><Sg> |\
di:<>e<>:njenigen	<+DEM><pro><NoGend><Dat><Pl> |\
di:<>e<>:nselben	<+DEM><pro><NoGend><Dat><Pl> |\
di:<>e<>:r		<+DEM><subst><Fem><Dat><Sg> |\
di:<>e<>:r		<+DEM><subst><Fem><Gen><Sg> |\
di:<>e<>:rjenige<>:n	<+DEM><pro><Fem><Dat><Sg> |\
di:<>e<>:rjenige<>:n	<+DEM><pro><Fem><Gen><Sg> |\
di:<>e<>:rjenigen	<+DEM><pro><NoGend><Gen><Pl> |\
di:<>e<>:rselbe<>:n	<+DEM><pro><Fem><Dat><Sg> |\
di:<>e<>:rselbe<>:n	<+DEM><pro><Fem><Gen><Sg> |\
di:<>e<>:rselben	<+DEM><pro><NoGend><Gen><Pl> |\
di:e<>:ne<>:n		<+DEM><subst><NoGend><Dat><Pl> |\
di:e<>:re<>:n		<+DEM><subst><Fem><Gen><Sg> |\
di:e<>:re<>:n		<+DEM><subst><NoGend><Gen><Pl> |\
di:e<>:re<>:r		<+DEM><subst><NoGend><Gen><Pl> |\
die			<+DEM><subst><Fem><Akk><Sg> |\
die			<+DEM><subst><Fem><Nom><Sg> |\
die			<+DEM><subst><NoGend><Akk><Pl> |\
die			<+DEM><subst><NoGend><Nom><Pl> |\
diejenige		<+DEM><pro><Fem><Akk><Sg> |\
diejenige		<+DEM><pro><Fem><Nom><Sg> |\
diejenigen		<+DEM><pro><NoGend><Akk><Pl> |\
diejenigen		<+DEM><pro><NoGend><Nom><Pl> |\
dies			<+DEM><pro><Neut><Akk><Sg> |\
dies			<+DEM><pro><Neut><Nom><Sg> |\
dies<>:e		<+DEM><pro><Fem><Akk><Sg> |\
dies<>:e		<+DEM><pro><Fem><Nom><Sg> |\
dies<>:e		<+DEM><pro><NoGend><Akk><Pl> |\
dies<>:e		<+DEM><pro><NoGend><Nom><Pl> |\
dies<>:e<>:m		<+DEM><pro><Masc><Dat><Sg> |\
dies<>:e<>:m		<+DEM><pro><Neut><Dat><Sg> |\
dies<>:e<>:n		<+DEM><pro><Masc><Akk><Sg> |\
dies<>:e<>:n		<+DEM><pro><NoGend><Dat><Pl> |\
dies<>:e<>:r		<+DEM><pro><Fem><Dat><Sg> |\
dies<>:e<>:r		<+DEM><pro><Fem><Gen><Sg> |\
dies<>:e<>:r		<+DEM><pro><Masc><Nom><Sg> |\
dies<>:e<>:r		<+DEM><pro><NoGend><Gen><Pl> |\
dies<>:e<>:s		<+DEM><pro><Masc><Gen><Sg> |\
dies<>:e<>:s		<+DEM><pro><Neut><Akk><Sg> |\
dies<>:e<>:s		<+DEM><pro><Neut><Gen><Sg> |\
dies<>:e<>:s		<+DEM><pro><Neut><Nom><Sg> |\
dieselbe		<+DEM><pro><Fem><Akk><Sg> |\
dieselbe		<+DEM><pro><Fem><Nom><Sg> |\
dieselben		<+DEM><pro><NoGend><Akk><Pl> |\
dieselben		<+DEM><pro><NoGend><Nom><Pl> |\
ebendies<>:e		<+DEM><pro><Fem><Akk><Sg> |\
ebendies<>:e		<+DEM><pro><Fem><Nom><Sg> |\
ebendies<>:e		<+DEM><pro><NoGend><Akk><Pl> |\
ebendies<>:e		<+DEM><pro><NoGend><Nom><Pl> |\
ebendies<>:e<>:m	<+DEM><pro><Masc><Dat><Sg> |\
ebendies<>:e<>:m	<+DEM><pro><Neut><Dat><Sg> |\
ebendies<>:e<>:n	<+DEM><pro><Masc><Akk><Sg> |\
ebendies<>:e<>:n	<+DEM><pro><NoGend><Dat><Pl> |\
ebendies<>:e<>:r	<+DEM><pro><Fem><Dat><Sg> |\
ebendies<>:e<>:r	<+DEM><pro><Fem><Gen><Sg> |\
ebendies<>:e<>:r	<+DEM><pro><Masc><Nom><Sg> |\
ebendies<>:e<>:r	<+DEM><pro><NoGend><Gen><Pl> |\
ebendies<>:e<>:s	<+DEM><pro><Masc><Gen><Sg> |\
ebendies<>:e<>:s	<+DEM><pro><Neut><Akk><Sg> |\
ebendies<>:e<>:s	<+DEM><pro><Neut><Gen><Sg> |\
ebendies<>:e<>:s	<+DEM><pro><Neut><Nom><Sg> |\
jen<>:e			<+DEM><pro><Fem><Akk><Sg> |\
jen<>:e			<+DEM><pro><Fem><Nom><Sg> |\
jen<>:e			<+DEM><pro><NoGend><Akk><Pl> |\
jen<>:e			<+DEM><pro><NoGend><Nom><Pl> |\
jen<>:e<>:m		<+DEM><pro><Masc><Dat><Sg> |\
jen<>:e<>:m		<+DEM><pro><Neut><Dat><Sg> |\
jen<>:e<>:n		<+DEM><pro><Masc><Akk><Sg> |\
jen<>:e<>:n		<+DEM><pro><NoGend><Dat><Pl> |\
jen<>:e<>:r		<+DEM><attr><Fem><Gen><Sg> |\
jen<>:e<>:r		<+DEM><attr><NoGend><Gen><Pl> |\
jen<>:e<>:r		<+DEM><pro><Fem><Dat><Sg> |\
jen<>:e<>:r		<+DEM><pro><Masc><Nom><Sg> |\
jen<>:e<>:s		<+DEM><attr><Masc><Gen><Sg> |\
jen<>:e<>:s		<+DEM><attr><Neut><Gen><Sg> |\
jen<>:e<>:s		<+DEM><pro><Neut><Akk><Sg> |\
jen<>:e<>:s		<+DEM><pro><Neut><Nom><Sg> |\
selb<>:e		<+DEM><pro><Neut><Nom><Sg> |\
selb<>:e<>:m		<+DEM><pro><Masc><Dat><Sg> |\
selb<>:e<>:m		<+DEM><pro><Neut><Dat><Sg> |\
selb<>:e<>:n		<+DEM><attr><Masc><Dat><Sg> |\
selb<>:e<>:n		<+DEM><pro><Masc><Akk><Sg> |\
selb<>:e<>:n		<+DEM><pro><Neut><Akk><Sg> |\
selb<>:e<>:s		<+DEM><pro><Neut><Akk><Sg> |\
selb<>:i<>:g<>:e	<+DEM><pro><Fem><Akk><Sg> |\
selb<>:i<>:g<>:e	<+DEM><pro><Fem><Nom><Sg> |\
selb<>:i<>:g<>:e<>:m	<+DEM><pro><Masc><Dat><Sg> |\
selb<>:i<>:g<>:e<>:m	<+DEM><pro><Neut><Dat><Sg> |\
selb<>:i<>:g<>:e<>:n	<+DEM><pro><Masc><Akk><Sg> |\
selb<>:i<>:g<>:e<>:n	<+DEM><pro><Masc><Gen><Sg> |\
selb<>:i<>:g<>:e<>:r	<+DEM><pro><Fem><Dat><Sg> |\
selb<>:i<>:g<>:e<>:r	<+DEM><pro><Fem><Gen><Sg> |\
selb<>:i<>:g<>:e<>:r	<+DEM><pro><Masc><Nom><Sg> |\
selb<>:i<>:g<>:e<>:s	<+DEM><pro><Neut><Akk><Sg> |\
selb<>:i<>:g<>:e<>:s	<+DEM><pro><Neut><Nom><Sg> |\
% Indefinite Pronouns
all			<+INDEF><mD> |\
alle			<+INDEF><attr><Fem><Akk><Sg><mD> |\
alle			<+INDEF><attr><Fem><Nom><Sg><mD> |\
alle			<+INDEF><pro><NoGend><Akk><Pl><mD> |\
alle			<+INDEF><pro><NoGend><Nom><Pl><mD> |\
alle<>:m		<+INDEF><attr><Masc><Dat><Sg><mD> |\
alle<>:m		<+INDEF><pro><Neut><Dat><Sg><mD> |\
alle<>:n		<+INDEF><attr><Masc><Akk><Sg><mD> |\
alle<>:n		<+INDEF><attr><Masc><Gen><Sg><mD> |\
alle<>:n		<+INDEF><pro><NoGend><Dat><Pl><mD> |\
alle<>:r		<+INDEF><attr><Fem><Dat><Sg><mD> |\
alle<>:r		<+INDEF><attr><Fem><Gen><Sg><mD> |\
alle<>:r		<+INDEF><attr><Masc><Nom><Sg><mD> |\
alle<>:r		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
alle<>:s		<+INDEF><pro><Neut><Akk><Sg><mD> |\
alle<>:s		<+INDEF><pro><Neut><Nom><Sg><mD> |\
allerlei		<+INDEF><pro><oD> |\
ander<>:e		<+INDEF><subst><Fem><Akk><Sg><mD> |\
ander<>:e		<+INDEF><subst><Fem><Nom><Sg><mD> |\
ander<>:e		<+INDEF><subst><Masc><Nom><Sg><mD> |\
ander<>:e		<+INDEF><subst><Neut><Akk><Sg><mD> |\
ander<>:e		<+INDEF><subst><Neut><Nom><Sg><mD> |\
ander<>:e		<+INDEF><subst><NoGend><Nom><Pl><mD> |\
ander<>:e<>:n		<+INDEF><subst><Fem><Dat><Sg><mD> |\
ander<>:e<>:n		<+INDEF><subst><Masc><Akk><Sg><mD> |\
ander<>:e<>:n		<+INDEF><subst><Masc><Dat><Sg><mD> |\
ander<>:e<>:n		<+INDEF><subst><Neut><Dat><Sg><mD> |\
ander<>:e<>:n		<+INDEF><subst><NoGend><Akk><Pl><mD> |\
ander<>:e<>:n		<+INDEF><subst><NoGend><Dat><Pl><mD> |\
ander<>:e<>:r		<+INDEF><subst><NoGend><Gen><Pl><mD> |\
ander<>:e<>:s		<+INDEF><subst><Neut><Akk><Sg><mD> |\
anderlei		<+INDEF><pro><oD> |\
beide			<+INDEF><pro><NoGend><Akk><Pl><mD> |\
beide			<+INDEF><pro><NoGend><Nom><Pl><mD> |\
beide<>:m		<+INDEF><subst><Neut><Dat><Sg> |\
beide<>:n		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
beide<>:n		<+INDEF><pro><NoGend><Dat><Pl><mD> |\
beide<>:n		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
beide<>:n		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
beide<>:r		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
beide<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
beide<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
beiderlei		<+INDEF><pro><oD> |\
bichen			<+INDEF><pro><mD> |\
bisschen		<+INDEF><pro><mD> |\
deinesgleichen		<+INDEF><subst><NoGend><Akk><Sg> |\
deinesgleichen		<+INDEF><subst><NoGend><Dat><Sg> |\
deinesgleichen		<+INDEF><subst><NoGend><Nom><Sg> |\
dergleichen		<+INDEF><subst><NoGend><Akk><Sg> |\
dergleichen		<+INDEF><subst><NoGend><Dat><Sg> |\
dergleichen		<+INDEF><subst><NoGend><Nom><Sg> |\
derlei			<+INDEF><pro><oD> |\
dreierlei		<+INDEF><pro><oD> |\
ebensoviel<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
ebensoviel<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
ebensoviel<>:e<>:m	<+INDEF><subst><Neut><Dat><Sg> |\
ebensoviel<>:e<>:n	<+INDEF><pro><NoGend><Akk><Pl><oD> |\
ebensoviel<>:e<>:n	<+INDEF><pro><NoGend><Dat><Pl><oD> |\
ebensoviel<>:e<>:n	<+INDEF><pro><NoGend><Gen><Pl><oD> |\
ebensoviel<>:e<>:n	<+INDEF><pro><NoGend><Nom><Pl><oD> |\
ebensoviel<>:e<>:r	<+INDEF><pro><NoGend><Gen><Pl><oD> |\
ebensoviel<>:e<>:s	<+INDEF><subst><Neut><Akk><Sg> |\
ebensoviel<>:e<>:s	<+INDEF><subst><Neut><Nom><Sg> |\
ebensowenig<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
ebensowenig<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
ebensowenig<>:e		<+INDEF><subst><Neut><Akk><Sg> |\
ebensowenig<>:e		<+INDEF><subst><Neut><Nom><Sg> |\
ebensowenig<>:e<>:n	<+INDEF><pro><NoGend><Akk><Pl><oD> |\
ebensowenig<>:e<>:n	<+INDEF><pro><NoGend><Dat><Pl><oD> |\
ebensowenig<>:e<>:n	<+INDEF><pro><NoGend><Gen><Pl><oD> |\
ebensowenig<>:e<>:n	<+INDEF><pro><NoGend><Nom><Pl><oD> |\
ebensowenig<>:e<>:n	<+INDEF><subst><Neut><Dat><Sg> |\
ebensowenig<>:e<>:r	<+INDEF><pro><NoGend><Gen><Pl><oD> |\
ebensowenig<>:e<>:s	<+INDEF><subst><Neut><Akk><Sg> |\
ein<>:e			<+INDEF><subst><Fem><Akk><Sg> |\
ein<>:e			<+INDEF><subst><Fem><Nom><Sg> |\
ein<>:e<>:m		<+INDEF><subst><Masc><Dat><Sg> |\
ein<>:e<>:m		<+INDEF><subst><Neut><Dat><Sg> |\
ein<>:e<>:n		<+INDEF><subst><Masc><Akk><Sg> |\
ein<>:e<>:r		<+INDEF><subst><Fem><Dat><Sg> |\
ein<>:e<>:r		<+INDEF><subst><Masc><Nom><Sg> |\
ein<>:e<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
ein<>:e<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
einerlei		<+INDEF><pro><oD> |\
einige			<+INDEF><attr><Fem><Akk><Sg><oD> |\
einige			<+INDEF><attr><Fem><Nom><Sg><oD> |\
einige			<+INDEF><pro><NoGend><Akk><Pl><oD> |\
einige			<+INDEF><pro><NoGend><Nom><Pl><oD> |\
einige<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
einige<>:r		<+INDEF><attr><Fem><Dat><Sg><oD> |\
einige<>:r		<+INDEF><attr><Fem><Gen><Sg><oD> |\
einige<>:r		<+INDEF><pro><NoGend><Gen><Pl><oD> |\
einiger			<+INDEF><attr><Masc><Nom><Sg><oD> |\
einiger:m		<+INDEF><attr><Masc><Dat><Sg><oD> |\
einiger:n		<+INDEF><attr><Masc><Akk><Sg><oD> |\
einiger:n		<+INDEF><attr><Masc><Gen><Sg><oD> |\
einiger:s		<+INDEF><attr><Masc><Gen><Sg><oD> |\
einiges			<+INDEF><attr><Neut><Gen><Sg><oD> |\
einiges			<+INDEF><pro><Neut><Akk><Sg><oD> |\
einiges			<+INDEF><pro><Neut><Nom><Sg><oD> |\
einiges:m		<+INDEF><subst><Neut><Dat><Sg> |\
erster<>:e		<+INDEF><pro><Fem><Akk><Sg><oD> |\
erster<>:e		<+INDEF><pro><Fem><Nom><Sg><oD> |\
erster<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
erster<>:e<>:m		<+INDEF><pro><Masc><Dat><Sg><oD> |\
erster<>:e<>:m		<+INDEF><pro><Neut><Dat><Sg><oD> |\
erster<>:e<>:n		<+INDEF><pro><Masc><Akk><Sg><oD> |\
erster<>:e<>:n		<+INDEF><pro><Masc><Gen><Sg><oD> |\
erster<>:e<>:n		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
erster<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
erster<>:e<>:r		<+INDEF><pro><Fem><Dat><Sg><oD> |\
erster<>:e<>:r		<+INDEF><pro><Fem><Gen><Sg><oD> |\
erster<>:e<>:r		<+INDEF><pro><Masc><Nom><Sg><oD> |\
erster<>:e<>:s		<+INDEF><pro><Neut><Akk><Sg><oD> |\
erster<>:e<>:s		<+INDEF><pro><Neut><Nom><Sg><oD> |\
etlich<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
etlich<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
etlich<>:e<>:m		<+INDEF><pro><Neut><Dat><Sg><oD> |\
etlich<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
etlich<>:e<>:r		<+INDEF><pro><NoGend><Gen><Pl><oD> |\
etlich<>:e<>:s		<+INDEF><pro><Neut><Akk><Sg><oD> |\
etlich<>:e<>:s		<+INDEF><pro><Neut><Nom><Sg><oD> |\
etwas			<+INDEF><pro><Neut><Akk><Sg><oD> |\
etwas			<+INDEF><pro><Neut><Dat><Sg><oD> |\
etwas			<+INDEF><pro><Neut><Nom><Sg><oD> |\
etwelch<>:e		<+INDEF><attr><NoGend><Akk><Pl><oD> |\
etwelch<>:e<>:m		<+INDEF><attr><Masc><Dat><Sg><oD> |\
etwelch<>:e<>:m		<+INDEF><attr><Neut><Dat><Sg><oD> |\
etwelch<>:e<>:n		<+INDEF><attr><NoGend><Dat><Pl><oD> |\
etwelch<>:e<>:r		<+INDEF><attr><Fem><Dat><Sg><oD> |\
etwelch<>:e<>:s		<+INDEF><attr><Neut><Akk><Sg><oD> |\
euresgleichen		<+INDEF><subst><NoGend><Akk><Pl> |\
euresgleichen		<+INDEF><subst><NoGend><Dat><Pl> |\
euresgleichen		<+INDEF><subst><NoGend><Nom><Pl> |\
ihresgleichen		<+INDEF><subst><NoGend><Akk><Pl> |\
ihresgleichen		<+INDEF><subst><NoGend><Dat><Pl> |\
ihresgleichen		<+INDEF><subst><NoGend><Nom><Pl> |\
irgendein		<+INDEF><attr><Masc><Nom><Sg><oD> |\
irgendein		<+INDEF><attr><Neut><Akk><Sg><oD> |\
irgendein		<+INDEF><attr><Neut><Nom><Sg><oD> |\
irgendein<>:e		<+INDEF><pro><Fem><Akk><Sg><oD> |\
irgendein<>:e		<+INDEF><pro><Fem><Nom><Sg><oD> |\
irgendein<>:e<>:m	<+INDEF><pro><Masc><Dat><Sg><oD> |\
irgendein<>:e<>:m	<+INDEF><pro><Neut><Dat><Sg><oD> |\
irgendein<>:e<>:n	<+INDEF><pro><Masc><Akk><Sg><oD> |\
irgendein<>:e<>:r	<+INDEF><pro><Fem><Dat><Sg><oD> |\
irgendein<>:e<>:r	<+INDEF><pro><Fem><Gen><Sg><oD> |\
irgendein<>:e<>:r	<+INDEF><subst><Masc><Nom><Sg> |\
irgendein<>:e<>:s	<+INDEF><pro><Masc><Gen><Sg><oD> |\
irgendein<>:e<>:s	<+INDEF><pro><Neut><Gen><Sg><oD> |\
irgendein<>:e<>:s	<+INDEF><subst><Neut><Akk><Sg> |\
irgendein<>:e<>:s	<+INDEF><subst><Neut><Nom><Sg> |\
irgendetwas		<+INDEF><pro><Neut><Akk><Sg><oD> |\
irgendetwas		<+INDEF><pro><Neut><Nom><Sg><oD> |\
irgendjemand		<+INDEF><subst><NoGend><Akk><Sg> |\
irgendjemand		<+INDEF><subst><NoGend><Nom><Sg> |\
irgendjemand<>:e<>:m	<+INDEF><subst><NoGend><Dat><Sg> |\
irgendjemand<>:e<>:n	<+INDEF><subst><NoGend><Akk><Sg> |\
irgendjemand<>:e<>:s	<+INDEF><subst><NoGend><Gen><Sg> |\
irgendwas		<+INDEF><pro><Neut><Akk><Sg><oD> |\
irgendwas		<+INDEF><pro><Neut><Nom><Sg><oD> |\
irgendwelch<>:e		<+INDEF><pro><Fem><Akk><Sg><oD> |\
irgendwelch<>:e		<+INDEF><pro><Fem><Nom><Sg><oD> |\
irgendwelch<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
irgendwelch<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
irgendwelch<>:e<>:m	<+INDEF><pro><Masc><Dat><Sg><oD> |\
irgendwelch<>:e<>:m	<+INDEF><pro><Neut><Dat><Sg><oD> |\
irgendwelch<>:e<>:n	<+INDEF><attr><Masc><Gen><Sg><oD> |\
irgendwelch<>:e<>:n	<+INDEF><pro><Masc><Akk><Sg><oD> |\
irgendwelch<>:e<>:n	<+INDEF><pro><NoGend><Dat><Pl><oD> |\
irgendwelch<>:e<>:r	<+INDEF><pro><Fem><Dat><Sg><oD> |\
irgendwelch<>:e<>:r	<+INDEF><pro><Fem><Gen><Sg><oD> |\
irgendwelch<>:e<>:r	<+INDEF><pro><Masc><Nom><Sg><oD> |\
irgendwelch<>:e<>:r	<+INDEF><pro><NoGend><Gen><Pl><oD> |\
irgendwelch<>:e<>:s	<+INDEF><pro><Neut><Akk><Sg><oD> |\
irgendwelch<>:e<>:s	<+INDEF><pro><Neut><Gen><Sg><oD> |\
irgendwelch<>:e<>:s	<+INDEF><pro><Neut><Nom><Sg><oD> |\
irgendwem		<+INDEF><subst><NoGend><Dat><Sg> |\
irgendwen		<+INDEF><subst><NoGend><Akk><Sg> |\
irgendwer		<+INDEF><subst><NoGend><Nom><Sg> |\
irgendwessen		<+INDEF><subst><Gen><Sg> |\
jed<>:e			<+INDEF><pro><Fem><Akk><Sg><mD> |\
jed<>:e			<+INDEF><pro><Fem><Nom><Sg><mD> |\
jed<>:e<>:m		<+INDEF><subst><Masc><Dat><Sg> |\
jed<>:e<>:m		<+INDEF><subst><Neut><Dat><Sg> |\
jed<>:e<>:n		<+INDEF><attr><Fem><Dat><Sg><mD> |\
jed<>:e<>:n		<+INDEF><attr><Fem><Gen><Sg><mD> |\
jed<>:e<>:n		<+INDEF><attr><Masc><Dat><Sg><mD> |\
jed<>:e<>:n		<+INDEF><attr><Masc><Gen><Sg><mD> |\
jed<>:e<>:n		<+INDEF><attr><Neut><Dat><Sg><mD> |\
jed<>:e<>:n		<+INDEF><attr><Neut><Gen><Sg><mD> |\
jed<>:e<>:n		<+INDEF><pro><Masc><Akk><Sg><mD> |\
jed<>:e<>:r		<+INDEF><attr><Fem><Gen><Sg><mD> |\
jed<>:e<>:r		<+INDEF><pro><Fem><Dat><Sg><mD> |\
jed<>:e<>:r		<+INDEF><pro><Masc><Nom><Sg><mD> |\
jed<>:e<>:s		<+INDEF><attr><Masc><Gen><Sg><mD> |\
jed<>:e<>:s		<+INDEF><attr><Neut><Gen><Sg><mD> |\
jed<>:e<>:s		<+INDEF><pro><Neut><Akk><Sg><mD> |\
jed<>:e<>:s		<+INDEF><pro><Neut><Nom><Sg><mD> |\
jedermann		<+INDEF><subst><NoGend><Akk><Sg> |\
jedermann		<+INDEF><subst><NoGend><Dat><Sg> |\
jedermann		<+INDEF><subst><NoGend><Nom><Sg> |\
jedermanns		<+INDEF><attr><NoGend><Nom><Sg><oD> |\
jedermanns		<+INDEF><subst><NoGend><Gen><Sg> |\
jedwed<>:e		<+INDEF><attr><Fem><Akk><Sg><oD> |\
jedwed<>:e		<+INDEF><attr><Fem><Nom><Sg><oD> |\
jedwed<>:e<>:m		<+INDEF><attr><Masc><Dat><Sg><oD> |\
jedwed<>:e<>:m		<+INDEF><attr><Neut><Dat><Sg><oD> |\
jedwed<>:e<>:n		<+INDEF><attr><Masc><Akk><Sg><oD> |\
jedwed<>:e<>:n		<+INDEF><attr><Neut><Akk><Sg><oD> |\
jedwed<>:e<>:r		<+INDEF><attr><Fem><Dat><Sg><oD> |\
jedwed<>:e<>:r		<+INDEF><attr><Masc><Nom><Sg><oD> |\
jedwed<>:e<>:s		<+INDEF><attr><Neut><Nom><Sg><oD> |\
jeglich<>:e		<+INDEF><attr><Fem><Akk><Sg><oD> |\
jeglich<>:e		<+INDEF><attr><Fem><Nom><Sg><oD> |\
jeglich<>:e		<+INDEF><attr><NoGend><Akk><Pl><oD> |\
jeglich<>:e		<+INDEF><attr><NoGend><Nom><Pl><oD> |\
jeglich<>:e<>:m		<+INDEF><attr><Masc><Dat><Sg><oD> |\
jeglich<>:e<>:m		<+INDEF><attr><Neut><Dat><Sg><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><Fem><Dat><Sg><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><Fem><Gen><Sg><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><Masc><Akk><Sg><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><Masc><Gen><Sg><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><Neut><Gen><Sg><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><NoGend><Akk><Pl><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><NoGend><Dat><Pl><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><NoGend><Gen><Pl><oD> |\
jeglich<>:e<>:n		<+INDEF><attr><NoGend><Nom><Pl><oD> |\
jeglich<>:e<>:r		<+INDEF><attr><Masc><Nom><Sg><oD> |\
jeglich<>:e<>:r		<+INDEF><attr><NoGend><Gen><Pl><oD> |\
jeglich<>:e<>:s		<+INDEF><attr><Neut><Akk><Sg><oD> |\
jeglich<>:e<>:s		<+INDEF><attr><Neut><Nom><Sg><oD> |\
jemand			<+INDEF><subst><NoGend><Akk><Sg> |\
jemand			<+INDEF><subst><NoGend><Nom><Sg> |\
jemand<>:e<>:m		<+INDEF><subst><NoGend><Dat><Sg> |\
jemand<>:e<>:n		<+INDEF><subst><NoGend><Akk><Sg> |\
jemand<>:e<>:s		<+INDEF><subst><NoGend><Gen><Sg> |\
kein			<+INDEF><attr><Masc><Nom><Sg><oD> |\
kein			<+INDEF><attr><Neut><Akk><Sg><oD> |\
kein			<+INDEF><attr><Neut><Nom><Sg><oD> |\
kein<>:e		<+INDEF><pro><Fem><Akk><Sg><oD> |\
kein<>:e		<+INDEF><pro><Fem><Nom><Sg><oD> |\
kein<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
kein<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
kein<>:e<>:m		<+INDEF><attr><Neut><Dat><Sg><oD> |\
kein<>:e<>:m		<+INDEF><pro><Masc><Dat><Sg><oD> |\
kein<>:e<>:n		<+INDEF><pro><Masc><Akk><Sg><oD> |\
kein<>:e<>:r		<+INDEF><pro><Fem><Dat><Sg><oD> |\
kein<>:e<>:r		<+INDEF><subst><Masc><Nom><Sg> |\
kein<>:e<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
kein<>:e<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
kein<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
kein<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
keinerlei		<+INDEF><attr><oD> |\
lauter			<+INDEF><attr><oD> |\
letzter<>:e		<+INDEF><pro><Fem><Akk><Sg><oD> |\
letzter<>:e		<+INDEF><pro><Fem><Nom><Sg><oD> |\
letzter<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
letzter<>:e<>:m		<+INDEF><pro><Masc><Dat><Sg><oD> |\
letzter<>:e<>:m		<+INDEF><pro><Neut><Dat><Sg><oD> |\
letzter<>:e<>:n		<+INDEF><pro><Masc><Akk><Sg><oD> |\
letzter<>:e<>:n		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
letzter<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
letzter<>:e<>:r		<+INDEF><pro><Fem><Dat><Sg><oD> |\
letzter<>:e<>:r		<+INDEF><pro><Fem><Gen><Sg><oD> |\
letzter<>:e<>:r		<+INDEF><pro><Masc><Nom><Sg><oD> |\
letzter<>:e<>:s		<+INDEF><pro><Neut><Akk><Sg><oD> |\
letzter<>:e<>:s		<+INDEF><pro><Neut><Nom><Sg><oD> |\
man			<+INDEF><subst><NoGend><Nom><Sg> |\
manch			<+INDEF><attr><oD> |\
manch<>:e		<+INDEF><pro><Fem><Akk><Sg><oD> |\
manch<>:e		<+INDEF><pro><Fem><Nom><Sg><oD> |\
manch<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
manch<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
manch<>:e<>:m		<+INDEF><pro><Masc><Dat><Sg><oD> |\
manch<>:e<>:m		<+INDEF><pro><Neut><Dat><Sg><oD> |\
manch<>:e<>:n		<+INDEF><attr><Masc><Gen><Sg><oD> |\
manch<>:e<>:n		<+INDEF><attr><Neut><Gen><Sg><oD> |\
manch<>:e<>:n		<+INDEF><pro><Masc><Akk><Sg><oD> |\
manch<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
manch<>:e<>:r		<+INDEF><attr><NoGend><Gen><Pl><oD> |\
manch<>:e<>:r		<+INDEF><pro><Fem><Dat><Sg><oD> |\
manch<>:e<>:r		<+INDEF><pro><Fem><Gen><Sg><oD> |\
manch<>:e<>:r		<+INDEF><pro><Masc><Nom><Sg><oD> |\
manch<>:e<>:s		<+INDEF><pro><Masc><Gen><Sg><oD> |\
manch<>:e<>:s		<+INDEF><pro><Neut><Akk><Sg><oD> |\
manch<>:e<>:s		<+INDEF><pro><Neut><Nom><Sg><oD> |\
manch<>:e<>:s		<+INDEF><subst><Neut><Gen><Sg><oD> |\
mancherlei		<+INDEF><pro><oD> |\
mehr			<+INDEF><pro><oD> |\
mehrere			<+INDEF><pro><NoGend><Akk><Pl><oD> |\
mehrere			<+INDEF><pro><NoGend><Nom><Pl><oD> |\
mehrere<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
mehrere<>:r		<+INDEF><pro><NoGend><Gen><Pl><oD> |\
mehreres		<+INDEF><subst><Neut><Akk><Sg> |\
mehreres		<+INDEF><subst><Neut><Nom><Sg> |\
mehrerlei		<+INDEF><pro><oD> |\
meinesgleichen		<+INDEF><subst><NoGend><Akk><Sg> |\
meinesgleichen		<+INDEF><subst><NoGend><Dat><Sg> |\
meinesgleichen		<+INDEF><subst><NoGend><Nom><Sg> |\
meist<>:e		<+INDEF><attr><Fem><Akk><Sg><mD> |\
meist<>:e		<+INDEF><attr><Fem><Nom><Sg><mD> |\
meist<>:e		<+INDEF><attr><Masc><Nom><Sg><mD> |\
meist<>:e		<+INDEF><pro><Neut><Akk><Sg><mD> |\
meist<>:e		<+INDEF><pro><Neut><Nom><Sg><mD> |\
meist<>:e<>:n		<+INDEF><attr><Fem><Dat><Sg><mD> |\
meist<>:e<>:n		<+INDEF><attr><Fem><Gen><Sg><mD> |\
meist<>:e<>:n		<+INDEF><attr><Masc><Akk><Sg><mD> |\
meist<>:e<>:n		<+INDEF><attr><Masc><Dat><Sg><mD> |\
meist<>:e<>:n		<+INDEF><attr><Masc><Gen><Sg><mD> |\
meist<>:e<>:n		<+INDEF><attr><Neut><Dat><Sg><mD> |\
meist<>:e<>:n		<+INDEF><pro><Neut><Gen><Sg><mD> |\
meist<>:e<>:n		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
meist<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><mD> |\
meist<>:e<>:n		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
meist<>:e<>:n		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
nichts			<+INDEF><subst><Neut><Akk><Sg> |\
nichts			<+INDEF><subst><Neut><Dat><Sg> |\
nichts			<+INDEF><subst><Neut><Nom><Sg> |\
niemand			<+INDEF><subst><NoGend><Akk><Sg> |\
niemand			<+INDEF><subst><NoGend><Nom><Sg> |\
niemand<>:e<>:m		<+INDEF><subst><NoGend><Dat><Sg> |\
niemand<>:e<>:n		<+INDEF><subst><NoGend><Akk><Sg> |\
niemand<>:e<>:s		<+INDEF><subst><NoGend><Gen><Sg> |\
nix			<+INDEF><subst><Neut><Akk><Sg> |\
nix			<+INDEF><subst><Neut><Dat><Sg> |\
nix			<+INDEF><subst><Neut><Nom><Sg> |\
paar			<+INDEF><pro><mD> |\
reichlich		<+INDEF><pro><oD> |\
seinesgleichen		<+INDEF><subst><NoGend><Akk><Sg> |\
seinesgleichen		<+INDEF><subst><NoGend><Dat><Sg> |\
seinesgleichen		<+INDEF><subst><NoGend><Nom><Sg> |\
solch			<+INDEF><mD> |\
solch<>:e		<+INDEF><pro><Fem><Akk><Sg><mD> |\
solch<>:e		<+INDEF><pro><Fem><Nom><Sg><mD> |\
solch<>:e		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
solch<>:e		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
solch<>:e<>:m		<+INDEF><pro><Masc><Dat><Sg><mD> |\
solch<>:e<>:m		<+INDEF><pro><Neut><Dat><Sg><mD> |\
solch<>:e<>:n			<+INDEF><pro><Masc><Akk><Sg><mD> |\
solch<>:e<>:n		<+INDEF><pro><Masc><Gen><Sg><mD> |\
solch<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><mD> |\
solch<>:e<>:r		<+INDEF><pro><Fem><Dat><Sg><mD> |\
solch<>:e<>:r		<+INDEF><pro><Fem><Gen><Sg><mD> |\
solch<>:e<>:r		<+INDEF><pro><Masc><Nom><Sg><mD> |\
solch<>:e<>:r		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
solch<>:e<>:s		<+INDEF><pro><Masc><Gen><Sg><mD> |\
solch<>:e<>:s		<+INDEF><pro><Neut><Akk><Sg><mD> |\
solch<>:e<>:s		<+INDEF><pro><Neut><Gen><Sg><mD> |\
solch<>:e<>:s		<+INDEF><pro><Neut><Nom><Sg><mD> |\
solcherlei		<+INDEF><pro><oD> |\
sonstjemand		<+INDEF><subst><NoGend><Akk><Sg> |\
sonstjemand		<+INDEF><subst><NoGend><Nom><Sg> |\
sonstjemand<>:e<>:m	<+INDEF><subst><NoGend><Dat><Sg> |\
sonstjemand<>:e<>:n	<+INDEF><subst><NoGend><Akk><Sg> |\
sonstjemand<>:e<>:s	<+INDEF><subst><NoGend><Gen><Sg> |\
sonstwas		<+INDEF><subst><Neut><Akk><Sg> |\
sonstwas		<+INDEF><subst><Neut><Dat><Sg> |\
sonstwas		<+INDEF><subst><Neut><Nom><Sg> |\
sonstwem		<+INDEF><subst><NoGend><Dat><Sg> |\
sonstwen		<+INDEF><subst><NoGend><Akk><Sg> |\
sonstwer		<+INDEF><subst><NoGend><Nom><Sg> |\
soviel			<+INDEF><pro><oD> |\
smtlich<>:e		<+INDEF><attr><NoGend><Akk><Pl><mD> |\
smtlich<>:e		<+INDEF><attr><NoGend><Nom><Pl><mD> |\
smtlich<>:e<>:m	<+INDEF><pro><Neut><Dat><Sg><mD> |\
smtlich<>:e<>:n	<+INDEF><attr><NoGend><Akk><Pl><mD> |\
smtlich<>:e<>:n	<+INDEF><attr><NoGend><Dat><Pl><mD> |\
smtlich<>:e<>:n	<+INDEF><attr><NoGend><Gen><Pl><mD> |\
smtlich<>:e<>:n	<+INDEF><attr><NoGend><Nom><Pl><mD> |\
smtlich<>:e<>:r	<+INDEF><attr><NoGend><Gen><Pl><mD> |\
smtlich<>:e<>:s	<+INDEF><pro><Neut><Akk><Sg><mD> |\
smtlich<>:e<>:s	<+INDEF><pro><Neut><Nom><Sg><mD> |\
unsereinem		<+INDEF><subst><NoGend><Dat><Sg> |\
unsereinen		<+INDEF><subst><NoGend><Akk><Sg> |\
unsereiner		<+INDEF><subst><NoGend><Nom><Sg> |\
unsereines		<+INDEF><subst><NoGend><Gen><Sg> |\
unsereins		<+INDEF><subst><NoGend><Akk><Sg> |\
unsereins		<+INDEF><subst><NoGend><Nom><Sg> |\
unseresgleichen		<+INDEF><subst><NoGend><Akk><Pl> |\
unseresgleichen		<+INDEF><subst><NoGend><Dat><Pl> |\
unseresgleichen		<+INDEF><subst><NoGend><Nom><Pl> |\
unsresgleichen		<+INDEF><subst><NoGend><Akk><Pl> |\
unsresgleichen		<+INDEF><subst><NoGend><Dat><Pl> |\
unsresgleichen		<+INDEF><subst><NoGend><Nom><Pl> |\
viel			<+INDEF><pro><oD> |\
viel<>:e		<+INDEF><attr><Fem><Akk><Sg><mD> |\
viel<>:e		<+INDEF><attr><Fem><Nom><Sg><mD> |\
viel<>:e		<+INDEF><attr><Masc><Nom><Sg><mD> |\
viel<>:e		<+INDEF><pro><Neut><Akk><Sg><mD> |\
viel<>:e		<+INDEF><pro><Neut><Nom><Sg><mD> |\
viel<>:e		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
viel<>:e		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
viel<>:e<>:m		<+INDEF><subst><Neut><Dat><Sg> |\
viel<>:e<>:n		<+INDEF><attr><Fem><Dat><Sg><mD> |\
viel<>:e<>:n		<+INDEF><attr><Fem><Gen><Sg><mD> |\
viel<>:e<>:n		<+INDEF><attr><Masc><Akk><Sg><mD> |\
viel<>:e<>:n		<+INDEF><attr><Masc><Dat><Sg><mD> |\
viel<>:e<>:n		<+INDEF><attr><Masc><Gen><Sg><mD> |\
viel<>:e<>:n		<+INDEF><attr><Neut><Dat><Sg><mD> |\
viel<>:e<>:n		<+INDEF><pro><Neut><Gen><Sg><mD> |\
viel<>:e<>:n		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
viel<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><mD> |\
viel<>:e<>:n		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
viel<>:e<>:n		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
viel<>:e<>:r		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
viel<>:e<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
viel<>:e<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
vielerlei		<+INDEF><pro><oD> |\
was			<+INDEF><subst><Neut><Akk><Sg> |\
was			<+INDEF><subst><Neut><Dat><Sg> |\
was			<+INDEF><subst><Neut><Nom><Sg> |\
welch			<+INDEF><mD> |\
welch<>:e		<+INDEF><pro><Fem><Akk><Sg><oD> |\
welch<>:e		<+INDEF><pro><Fem><Nom><Sg><oD> |\
welch<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
welch<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
welch<>:e<>:m		<+INDEF><pro><Masc><Dat><Sg><oD> |\
welch<>:e<>:m		<+INDEF><pro><Neut><Dat><Sg><oD> |\
welch<>:e<>:n		<+INDEF><attr><Masc><Gen><Sg><oD> |\
welch<>:e<>:n		<+INDEF><pro><Masc><Akk><Sg><oD> |\
welch<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
welch<>:e<>:r		<+INDEF><pro><Fem><Dat><Sg><oD> |\
welch<>:e<>:r		<+INDEF><pro><Fem><Gen><Sg><oD> |\
welch<>:e<>:r		<+INDEF><pro><Masc><Nom><Sg><oD> |\
welch<>:e<>:r		<+INDEF><pro><NoGend><Gen><Pl><oD> |\
welch<>:e<>:s		<+INDEF><pro><Neut><Akk><Sg><oD> |\
welch<>:e<>:s		<+INDEF><pro><Neut><Gen><Sg><oD> |\
welch<>:e<>:s		<+INDEF><pro><Neut><Nom><Sg><oD> |\
wenig			<+INDEF><pro><mD> |\
wenig<>:e		<+INDEF><attr><Fem><Akk><Sg><mD> |\
wenig<>:e		<+INDEF><attr><Fem><Nom><Sg><mD> |\
wenig<>:e		<+INDEF><attr><Masc><Nom><Sg><mD> |\
wenig<>:e		<+INDEF><attr><Neut><Nom><Sg><mD> |\
wenig<>:e		<+INDEF><pro><Neut><Akk><Sg><mD> |\
wenig<>:e		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
wenig<>:e		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
wenig<>:e<>:m		<+INDEF><subst><Neut><Dat><Sg> |\
wenig<>:e<>:n		<+INDEF><attr><Fem><Dat><Sg><mD> |\
wenig<>:e<>:n		<+INDEF><attr><Masc><Akk><Sg><mD> |\
wenig<>:e<>:n		<+INDEF><attr><Masc><Dat><Sg><mD> |\
wenig<>:e<>:n		<+INDEF><pro><Neut><Dat><Sg><mD> |\
wenig<>:e<>:n		<+INDEF><pro><Neut><Gen><Sg><mD> |\
wenig<>:e<>:n		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
wenig<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><mD> |\
wenig<>:e<>:n		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
wenig<>:e<>:n		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
wenig<>:e<>:r		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
wenig<>:e<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
wenig<>:e<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
weniger			<+INDEF><pro><oD> |\
wenigst<>:e		<+INDEF><attr><Fem><Akk><Sg><mD> |\
wenigst<>:e		<+INDEF><attr><Fem><Nom><Sg><mD> |\
wenigst<>:e		<+INDEF><attr><Masc><Nom><Sg><mD> |\
wenigst<>:e		<+INDEF><pro><Neut><Akk><Sg><mD> |\
wenigst<>:e		<+INDEF><pro><Neut><Nom><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><attr><Fem><Dat><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><attr><Fem><Gen><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><attr><Masc><Akk><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><attr><Masc><Dat><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><attr><Masc><Gen><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><attr><Neut><Dat><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><pro><Neut><Gen><Sg><mD> |\
wenigst<>:e<>:n		<+INDEF><pro><NoGend><Akk><Pl><mD> |\
wenigst<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><mD> |\
wenigst<>:e<>:n		<+INDEF><pro><NoGend><Gen><Pl><mD> |\
wenigst<>:e<>:n		<+INDEF><pro><NoGend><Nom><Pl><mD> |\
zuviel			<+INDEF><attr><Neut><Dat><Sg><oD> |\
zuviel			<+INDEF><attr><Neut><Nom><Sg><oD> |\
zuviel			<+INDEF><pro><Neut><Akk><Sg><oD> |\
zuviel			<+INDEF><subst><Neut><Gen><Sg> |\
zuviel<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
zuviel<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
zuviel<>:e<>:m		<+INDEF><subst><Neut><Dat><Sg> |\
zuviel<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
zuviel<>:e<>:r		<+INDEF><pro><NoGend><Gen><Pl><oD> |\
zuviel<>:e<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
zuviel<>:e<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
zuwenig			<+INDEF><attr><Neut><Dat><Sg><oD> |\
zuwenig			<+INDEF><attr><Neut><Nom><Sg><oD> |\
zuwenig			<+INDEF><pro><Neut><Akk><Sg><oD> |\
zuwenig			<+INDEF><pro><oD> |\
zuwenig			<+INDEF><subst><Neut><Gen><Sg> |\
zuwenig<>:e		<+INDEF><pro><NoGend><Akk><Pl><oD> |\
zuwenig<>:e		<+INDEF><pro><NoGend><Nom><Pl><oD> |\
zuwenig<>:e<>:m		<+INDEF><subst><Neut><Dat><Sg> |\
zuwenig<>:e<>:n		<+INDEF><pro><NoGend><Dat><Pl><oD> |\
zuwenig<>:e<>:r		<+INDEF><pro><NoGend><Gen><Pl><oD> |\
zuwenig<>:e<>:s		<+INDEF><subst><Neut><Akk><Sg> |\
zuwenig<>:e<>:s		<+INDEF><subst><Neut><Nom><Sg> |\
zweierlei		<+INDEF><pro><oD> |\
% Wh Pronouns
was			<+WPRO><subst><Neut><Akk><Sg> |\
was			<+WPRO><subst><Neut><Nom><Sg> |\
welche			<+WPRO><pro><Fem><Akk><Sg> |\
welche			<+WPRO><pro><Fem><Nom><Sg> |\
welche			<+WPRO><pro><NoGend><Akk><Pl> |\
welche			<+WPRO><pro><NoGend><Nom><Pl> |\
welche<>:n		<+WPRO><pro><NoGend><Dat><Pl> |\
welche<>:r		<+WPRO><attr><Fem><Gen><Sg> |\
welche<>:r		<+WPRO><attr><NoGend><Gen><Pl> |\
welche<>:r		<+WPRO><pro><Fem><Dat><Sg> |\
welcher			<+WPRO><pro><Masc><Nom><Sg> |\
welcher:m		<+WPRO><pro><Masc><Dat><Sg> |\
welcher:n		<+WPRO><attr><Masc><Gen><Sg> |\
welcher:n		<+WPRO><pro><Masc><Akk><Sg> |\
welcher:s		<+WPRO><attr><Masc><Gen><Sg> |\
welches			<+WPRO><attr><Neut><Gen><Sg> |\
welches			<+WPRO><pro><Neut><Akk><Sg> |\
welches			<+WPRO><pro><Neut><Nom><Sg> |\
welches:m		<+WPRO><pro><Neut><Dat><Sg> |\
wer			<+WPRO><subst><NoGend><Nom><Sg> |\
wer:m			<+WPRO><subst><NoGend><Dat><Sg> |\
wer:n			<+WPRO><subst><NoGend><Akk><Sg> |\
wer:s<>:s<>:e<>:n	<+WPRO><subst><NoGend><Dat><Sg> |\
% Possessive Pronouns
dein			<+POSS><attr><Masc><Nom><Sg> |\
dein			<+POSS><attr><Neut><Akk><Sg> |\
dein			<+POSS><attr><Neut><Nom><Sg> |\
dein<>:e		<+POSS><pro><Fem><Akk><Sg> |\
dein<>:e		<+POSS><pro><Fem><Nom><Sg> |\
dein<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
dein<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
dein<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
dein<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
dein<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
dein<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
dein<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
dein<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
dein<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
dein<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
dein<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
dein<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
dein<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
dein<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
dein<>:s		<+POSS><subst><Neut><Akk><Sg> |\
dein<>:s		<+POSS><subst><Neut><Nom><Sg> |\
eue:[<>e]r<>:e		<+POSS><pro><Fem><Akk><Sg> |\
eue:[<>e]r<>:e		<+POSS><pro><Fem><Nom><Sg> |\
eue:[<>e]r<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
eue:[<>e]r<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
eue:[<>e]r<>:e<>:m	<+POSS><pro><Masc><Dat><Sg> |\
eue:[<>e]r<>:e<>:m	<+POSS><pro><Neut><Dat><Sg> |\
eue:[<>e]r<>:e<>:n	<+POSS><pro><Masc><Akk><Sg> |\
eue:[<>e]r<>:e<>:n	<+POSS><pro><NoGend><Dat><Pl> |\
eue:[<>e]r<>:e<>:r	<+POSS><pro><Fem><Dat><Sg> |\
eue:[<>e]r<>:e<>:r	<+POSS><pro><Fem><Gen><Sg> |\
eue:[<>e]r<>:e<>:r	<+POSS><pro><NoGend><Gen><Pl> |\
eue:[<>e]r<>:e<>:r	<+POSS><subst><Masc><Nom><Sg> |\
eue:[<>e]r<>:e<>:s	<+POSS><pro><Masc><Gen><Sg> |\
eue:[<>e]r<>:e<>:s	<+POSS><pro><Neut><Gen><Sg> |\
eue:[<>e]r<>:e<>:s	<+POSS><subst><Neut><Akk><Sg> |\
eue:[<>e]r<>:e<>:s	<+POSS><subst><Neut><Nom><Sg> |\
eue:[<>e]r<>:s		<+POSS><subst><Neut><Nom><Sg> |\
euer			<+POSS><attr><Masc><Nom><Sg> |\
euer			<+POSS><attr><Neut><Akk><Sg> |\
euer			<+POSS><attr><Neut><Nom><Sg> |\
euer<>:s		<+POSS><subst><Neut><Akk><Sg> |\
ihr			<+POSS><attr><Masc><Nom><Sg> |\
ihr			<+POSS><attr><Neut><Akk><Sg> |\
ihr			<+POSS><attr><Neut><Nom><Sg> |\
ihr<>:e			<+POSS><pro><Fem><Akk><Sg> |\
ihr<>:e			<+POSS><pro><Fem><Nom><Sg> |\
ihr<>:e			<+POSS><pro><NoGend><Akk><Pl> |\
ihr<>:e			<+POSS><pro><NoGend><Nom><Pl> |\
ihr<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
ihr<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
ihr<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
ihr<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
ihr<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
ihr<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
ihr<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
ihr<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
ihr<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
ihr<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
ihr<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
ihr<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
ihr<>:s			<+POSS><subst><Neut><Akk><Sg> |\
ihr<>:s			<+POSS><subst><Neut><Nom><Sg> |\
ihrig			<+POSS><attr><Masc><Nom><Sg> |\
ihrig			<+POSS><attr><Neut><Akk><Sg> |\
ihrig			<+POSS><attr><Neut><Nom><Sg> |\
ihrig<>:e		<+POSS><pro><Fem><Akk><Sg> |\
ihrig<>:e		<+POSS><pro><Fem><Nom><Sg> |\
ihrig<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
ihrig<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
ihrig<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
ihrig<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
ihrig<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
ihrig<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
ihrig<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
ihrig<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
ihrig<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
ihrig<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
ihrig<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
ihrig<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
ihrig<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
ihrig<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
ihrig<>:s		<+POSS><subst><Neut><Akk><Sg> |\
ihrig<>:s		<+POSS><subst><Neut><Nom><Sg> |\
mein			<+POSS><attr><Masc><Nom><Sg> |\
mein			<+POSS><attr><Neut><Akk><Sg> |\
mein			<+POSS><attr><Neut><Nom><Sg> |\
mein<>:e		<+POSS><pro><Fem><Akk><Sg> |\
mein<>:e		<+POSS><pro><Fem><Nom><Sg> |\
mein<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
mein<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
mein<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
mein<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
mein<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
mein<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
mein<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
mein<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
mein<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
mein<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
mein<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
mein<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
mein<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
mein<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
mein<>:s		<+POSS><subst><Neut><Akk><Sg> |\
mein<>:s		<+POSS><subst><Neut><Nom><Sg> |\
sein			<+POSS><attr><Masc><Nom><Sg> |\
sein			<+POSS><attr><Neut><Akk><Sg> |\
sein			<+POSS><attr><Neut><Nom><Sg> |\
sein<>:e		<+POSS><pro><Fem><Akk><Sg> |\
sein<>:e		<+POSS><pro><Fem><Nom><Sg> |\
sein<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
sein<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
sein<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
sein<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
sein<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
sein<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
sein<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
sein<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
sein<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
sein<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
sein<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
sein<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
sein<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
sein<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
sein<>:s		<+POSS><subst><Neut><Akk><Sg> |\
sein<>:s		<+POSS><subst><Neut><Nom><Sg> |\
unser			<+POSS><attr><Masc><Nom><Sg> |\
unser			<+POSS><attr><Neut><Akk><Sg> |\
unser			<+POSS><attr><Neut><Nom><Sg> |\
unser<>:e		<+POSS><pro><Fem><Akk><Sg> |\
unser<>:e		<+POSS><pro><Fem><Nom><Sg> |\
unser<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
unser<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
unser<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
unser<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
unser<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
unser<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
unser<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
unser<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
unser<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
unser<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
unser<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
unser<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
unser<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
unser<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
unser<>:s		<+POSS><subst><Neut><Akk><Sg> |\
unser<>:s		<+POSS><subst><Neut><Nom><Sg> |\
unsrig			<+POSS><attr><Masc><Nom><Sg> |\
unsrig			<+POSS><attr><Neut><Akk><Sg> |\
unsrig			<+POSS><attr><Neut><Nom><Sg> |\
unsrig<>:e		<+POSS><pro><Fem><Akk><Sg> |\
unsrig<>:e		<+POSS><pro><Fem><Nom><Sg> |\
unsrig<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
unsrig<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
unsrig<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
unsrig<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
unsrig<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
unsrig<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
unsrig<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
unsrig<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
unsrig<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
unsrig<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
unsrig<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
unsrig<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
unsrig<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
unsrig<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
unsrig<>:s		<+POSS><subst><Neut><Akk><Sg> |\
unsrig<>:s		<+POSS><subst><Neut><Nom><Sg>


% Upper-Case Pronouns

$Pro_Up$ = \
% Personal Pronouns
Du			<+PPRO><pers><2><Sg><NoGend><Nom> |\
Du:e<>:i<>:n<>:e<>:r	<+PPRO><pers><2><Sg><NoGend><Gen> |\
Du:i<>:c<>:h		<+PPRO><prfl><2><Sg><NoGend><Akk> |\
Du:i<>:r		<+PPRO><prfl><2><Sg><NoGend><Dat> |\
S:Ii:h<>:ne<>:n		<+PPRO><pers><3><Pl><NoGend><Dat> |\
S:Ii:h<>:re<>:r		<+PPRO><pers><3><Pl><NoGend><Gen> |\
S:sie:c<>:h		<+PPRO><refl><3><Pl><NoGend> |\
Sie			<+PPRO><pers><3><Pl><NoGend><Akk> |\
Sie			<+PPRO><pers><3><Pl><NoGend><Nom> |\
% Possessive Pronouns
Dein			<+POSS><attr><Masc><Nom><Sg> |\
Dein			<+POSS><attr><Neut><Akk><Sg> |\
Dein			<+POSS><attr><Neut><Nom><Sg> |\
Dein<>:e		<+POSS><pro><Fem><Akk><Sg> |\
Dein<>:e		<+POSS><pro><Fem><Nom><Sg> |\
Dein<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
Dein<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
Dein<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
Dein<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
Dein<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
Dein<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
Dein<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
Dein<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
Dein<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
Dein<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
Dein<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
Dein<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
Dein<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
Dein<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
Dein<>:s		<+POSS><subst><Neut><Akk><Sg> |\
Dein<>:s		<+POSS><subst><Neut><Nom><Sg> |\
Ihr			<+POSS><attr><Masc><Nom><Sg> |\
Ihr			<+POSS><attr><Neut><Akk><Sg> |\
Ihr			<+POSS><attr><Neut><Nom><Sg> |\
Ihr<>:e			<+POSS><pro><Fem><Akk><Sg> |\
Ihr<>:e			<+POSS><pro><Fem><Nom><Sg> |\
Ihr<>:e			<+POSS><pro><NoGend><Akk><Pl> |\
Ihr<>:e			<+POSS><pro><NoGend><Nom><Pl> |\
Ihr<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
Ihr<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
Ihr<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
Ihr<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
Ihr<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
Ihr<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
Ihr<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
Ihr<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
Ihr<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
Ihr<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
Ihr<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
Ihr<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
Ihr<>:s			<+POSS><subst><Neut><Akk><Sg> |\
Ihr<>:s			<+POSS><subst><Neut><Nom><Sg> |\
Ihrig			<+POSS><attr><Masc><Nom><Sg> |\
Ihrig			<+POSS><attr><Neut><Akk><Sg> |\
Ihrig			<+POSS><attr><Neut><Nom><Sg> |\
Ihrig<>:e		<+POSS><pro><Fem><Akk><Sg> |\
Ihrig<>:e		<+POSS><pro><Fem><Nom><Sg> |\
Ihrig<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
Ihrig<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
Ihrig<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
Ihrig<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
Ihrig<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
Ihrig<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
Ihrig<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
Ihrig<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
Ihrig<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
Ihrig<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
Ihrig<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
Ihrig<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
Ihrig<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
Ihrig<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
Ihrig<>:s		<+POSS><subst><Neut><Akk><Sg> |\
Ihrig<>:s		<+POSS><subst><Neut><Nom><Sg> |\
Unsrig			<+POSS><attr><Masc><Nom><Sg> |\
Unsrig			<+POSS><attr><Neut><Akk><Sg> |\
Unsrig			<+POSS><attr><Neut><Nom><Sg> |\
Unsrig<>:e		<+POSS><pro><Fem><Akk><Sg> |\
Unsrig<>:e		<+POSS><pro><Fem><Nom><Sg> |\
Unsrig<>:e		<+POSS><pro><NoGend><Akk><Pl> |\
Unsrig<>:e		<+POSS><pro><NoGend><Nom><Pl> |\
Unsrig<>:e<>:m		<+POSS><pro><Masc><Dat><Sg> |\
Unsrig<>:e<>:m		<+POSS><pro><Neut><Dat><Sg> |\
Unsrig<>:e<>:n		<+POSS><pro><Masc><Akk><Sg> |\
Unsrig<>:e<>:n		<+POSS><pro><NoGend><Dat><Pl> |\
Unsrig<>:e<>:r		<+POSS><pro><Fem><Dat><Sg> |\
Unsrig<>:e<>:r		<+POSS><pro><Fem><Gen><Sg> |\
Unsrig<>:e<>:r		<+POSS><pro><NoGend><Gen><Pl> |\
Unsrig<>:e<>:r		<+POSS><subst><Masc><Nom><Sg> |\
Unsrig<>:e<>:s		<+POSS><pro><Masc><Gen><Sg> |\
Unsrig<>:e<>:s		<+POSS><pro><Neut><Gen><Sg> |\
Unsrig<>:e<>:s		<+POSS><subst><Neut><Akk><Sg> |\
Unsrig<>:e<>:s		<+POSS><subst><Neut><Nom><Sg> |\
Unsrig<>:s		<+POSS><subst><Neut><Akk><Sg> |\
Unsrig<>:s		<+POSS><subst><Neut><Nom><Sg>


%**************************************************************************
% Resulting transducers
%**************************************************************************

$F$ =  [<+ART><+DEM><+INDEF><+POSS><+PPRO><+REL><+WPRO> \
	<1><2><3> \
	<Sg><Pl> \
	<Nom><Gen><Akk><Dat> \
	<Masc><Fem><Neut><NoGend> \
	<Def><Indef> \
	<pers><prfl><refl><rez><subst> \
	<attr><pro> \
	<mD><oD>]:<>

$Pro_Stems$ = ($Pro_Low$ <>:<Low#> | $Pro_Up$ <>:<Up#>) \
		|| <>:<NoHy> [A-Za-z]+ $F$* [<Low#><Up#>]
