/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri JAN  12 16:54:22 CET 2007
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QApplication>

#include "globdefines.h"
#include "mainwindow.hpp"
#include "astar.hpp"
#include "listviews.hpp"
#include <plib/ssg.h>
#include "messages.hpp"

// global variables !!!!
int g_mouse_mode=0;
int g_mouse_x=0;
int g_mouse_y=0;
int g_mouse_button=0;
sgVec3 g_poi; // point of interest
int g_window_w=0;
int g_window_h=0;
QSet<int> g_keyset;
int g_key=0;
int g_playmode=0;
int g_switch = 0;
long g_nextid=0;
bool g_debug= false;

Glcontrol    *g_gl=NULL;
QString g_prjpath;
QString g_apppath;
QString g_editor;
// Catalog
QString g_3dcatalogpath;
int g_3dcatalogkategorie=0;
QString g_scriptcatalogpath;
QString g_soundcatalogpath;
QString g_shadercatalogpath;
QString g_physikcatalogpath;
// Display
int g_displayfps;
int g_displayphfps;

Messages *g_messages = NULL;

FolderListItem *g_tmpItem=NULL;
FolderListItem *g_switchScene = NULL;
// AStar
aStar *gastar= NULL;

int main(int argc, char *argv[])
{
    int error=0;

    QApplication app(argc, argv);

    // translation
    QString locale = "qcake_" + QLocale::system().name();
    qDebug()<< locale;
    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name());
    app.installTranslator(&qtTranslator);
    QTranslator myappTranslator;
    myappTranslator.load(":/build/qcake_" + QLocale::system().name());
    app.installTranslator(&myappTranslator);
    //QLocale::setDefault(QLocale::C);
    // splash
    QSplashScreen *splash = new QSplashScreen(QPixmap(":/images/qcake.png"));
    splash->setWindowFlags(splash->windowFlags() | Qt::WindowStaysOnTopHint);
    splash->show();
    splash->showMessage("Initialize QCake Designer...", Qt::AlignRight | Qt::AlignTop, Qt::blue);
    QTimer::singleShot(2000, splash, SLOT(close()));

    // application
    g_apppath = QCoreApplication::applicationDirPath ();
 #ifdef    Q_OS_MACX
    g_apppath = ".";
 #endif
    qWarning(g_apppath.toAscii());
    Q_INIT_RESOURCE(dockwidgets);
    g_messages = new Messages;
    MainWindow mainWin;
    mainWin.show();
    if (splash) {
        delete splash;
    }
    error = app.exec();
    if (g_messages) {
        delete g_messages;
    }
    return (error);
}
