'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH DS2770 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2770
\- Battery Monitor and Charge Controller
.SH SYNOPSIS
.SS Temperature Voltage Current Memory and Switch.
.PP
.B 2E
[.]XXXXXXXXXXXX[XX][/[
.B amphours
|
.B current
|
.B currentbias
|
.B lock.[0-2|ALL]
|
.B memory
|
.B pages/page.[0-2|ALL]
|
.B PIO
|
.B sensed
|
.B temperature
|
.B vbias
|
.B vis
|
.B volt
|
.B volthours
|
.br
.B charge
|
.B cini
|
.B cstat0
|
.B cstat1
|
.B ctype
|
.B defaultpmod
|
.B pmod
|
.B refresh
|
.B timer
|
.br
.so man3/standard_mini.3so
]]
.SS Thermocouple
.PP
.B 2E
[.]XXXXXXXXXXXX[XX][/[
.B temperature
|
.B typeX/range_low
|
.B typeX/range_high
|
.B typeX/temperature
.SH FAMILY CODE
.PP
.I 2E
.SH SPECIAL PROPERTIES
.SS amphours
.I read-write, floating point
.br
Accumulated amperage read by current sensor. Units are in
.B Amp-hr
(Assumes internal 25mOhm resistor). Derived from
.I volthours
/ Rinternal.
.br
Formally 
.I amphours
is the integral of
.I current - currentbias
over time.
.SS current
.I read-only, floating point
.br
Current reading. Units are in
.B Amp
(Assumes internal 25 mOhm resistor). Derived from
.I vis
/ Rinternal.
.SS currentbias
.I read-write, floating point
.br
Fixed offset applied to each 
.I current
measurement. Used in the
.I amphours
value. Assumes internal 25mOhm resistor. Units are 
.B Amp
and range from -.08A to .08A.
.br
Derived from
.I vbias
/ Rinternal.
.SS lock.[0-2|ALL]
.I read-write, yes-no
.br
Lock either of the three eprom pages to prevent further writes. Apparently setting
.I lock
is permanent.
.SS memory
.I read-write, binary
.br
Access to the full 256 byte memory range. Much of this space is reserved or special use. User space is the
.I page
area.
.br
See the
.I DATASHEET
for a full memory map.
.SS pages/pages.[0-2|ALL]
.I read-write, binary
Two 16 byte  and one 8 byte areas of memory for user application. The
.I lock
property can prevent further alteration.
.br
NOTE that the
.I page
property is different from the common 
.I OWFS
implementation in that all of
.I memory
is not accessible.
.SS PIO
.I write-only, yes-no
.br
Controls the PIO pin allowing external switching.
.br
Writing "1" turns the PIO pin on (conducting). Writing "0" makes the pin non-conducting.
The logical state of the voltage can be read with the
.I sensed
property. This will reflect the current voltage at the pin, not the value sent to
.I PIO
.br
Note also that
.I PIO
will also be altered by the power-status of the
.I DS2670
See the datasheet for details.
.SS sensed
.I read-only, yes-no
.br
The logical voltage at the PIO pin. Useful only if the
.I PIO
property is set to "0" (non-conducting).
.br
Value will be 0 or 1 depending on the voltage threshold.
.SS temperature
.I read-only, floating point
.br
.I Temperature
read by the chip at high resolution (~13 bits). Units are selected from the invoking command line. See
.B owfs(1)
or
.B owhttpd(1)
for choices. Default is Celsius.
.br
Conversion is continuous.
.SS vbias
.I read-write, floating point
.br
Fixed offset applied to each
.I vis
measurement. Used for the
.I volthours
value. Units are in
.B Volts.
.br
Range \-2.0mV to 2.0mV
.SS vis
.I read-only, floating point
.br
Current sensor reading (unknown external resistor). Measures the voltage gradient between the Vis pins. Units are in
.B Volts
.br
The
.I vis
readings are integrated over time to provide the
.I volthours
property.
.br
The
.I current
reading is derived from
.I vis
assuming the internal 25 mOhm resistor is employed. There is no way to know this through software.
.SS volt
.I read-only, floating point
.br
Voltage read at the voltage sensor;. This is separate from the
.I vis
voltage that is used for
.I current
measurement. Units are
.B Volts
.br
Range is between 0 and 4.75V
.SS volthours
.I read-write, floating point
.br
Integral of
.I vis - vbias
over time. Units are in
.B volthours
.SH THERMOCOUPLE
.SS typeX/
.I directory
.br
Thermocouple circuit using the
.B  DS2770 (3)
to read the Seebeck voltage and the reference temperature. Since the type interpretation of the values read depends on the type of thermocouple, the correct directory must be chosen. Supported thermocouple types include types B, E, J, K, N, R, S and T.
.SS typeX/range_low typeX/ranges_high
.I read-only, flaoting point
.br
The lower and upper temperature supported by this thermocouple (at least by the conversion routines). In the globally chosen temperature units.
.SS typeX/temperature
.I read-only, floating point
.br
Thermocouple temperature. Requires a voltage and temperature conversion. Returned in globally chosen temperature units.
.br
Note: there are two types of temperature measurements possible. The
.I temperature
value in the main device directory is the reference temperature read at the chip. The
.I typeX/temperature
value is at the thermocouple junction, probably remote from the chip.
.SH OBSCURE PROPERTIES
.SS charge
.I write-only, yes-no
.br
Trigger the start (1) or stop(0) of charging. see the
.I DATASHEET
for details.
.SS cini cstat0 cstat1 ctype pmod
.I varies, yes-no
.br
Bit flags corresponding to various battery management functions of the chip. See the 
.I DATASHEET
for details of the identically named entries.
.br
In general, writing "0" corresponds to a 0 bit value, and non-zero corresponds to a 1 bit value.
.SS defaultpmod
.I read-write, yes-no
.br
Default power-on state for the corresponding properties.
.SS refresh
.I write-only, yes-no
.br
Writing anything to this file causes a refresh of parameters. See the
.SS timer
.I read-write, floating point
.br
A charge timer in units of
.B hours.
See the
.I DATASHEET
for details.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2770
The
.B DS2770 (3)
is a battery charging controller. It has elaborate charge estimation algorithms built in.
.PP
A number of interesting devices can be built with the
.B DS2770 
including thermocouples. Support for thermocouples in built into the software, using the embedded thermister as the cold junction temperature.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2770.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
