'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH DS2408 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2408
\- 1-Wire 8 Channel Addressable Switch
.SH SYNOPSIS
8 port switch
.PP
.B 29
[.]XXXXXXXXXXXX[XX][/[
.B latch.[0-7|ALL|BYTE]
|
.B LCD_M/[clear|home|screen|message]
|
.B LCD_H/[clear|home|yxscreen|screen|message|onoff]
|
.B LCD_H/redefchar.[0-7|ALL] LCD_H/redefchar_hex.[0-7|ALL]
|
.B PIO.[0-7|ALL|BYTE]
|
.B power
|
.B sensed.[0-7|ALL|BYTE]
|
.B strobe
|
.B por
|
.B set_alarm
|
.B out_of_testmode
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 29
.SH SPECIAL PROPERTIES
.SS latch.0 ... latch.7 latch.ALL latch.BYTE
.I read-write, binary
.br
The 8 pins (PIO) latch a bit when their state changes, either externally, or through a write to the pin. 
.br
Reading the
.I latch
property indicates that the latch has been set.
.br
Writing "true" (non-zero) to ANY 
.I latch 
will reset them all. (This is the hardware design).
.br
.I ALL
is all 
.I latch 
states, accessed simultaneously, comma separated.
.br
.I BYTE
references all channels simultaneously as a single byte. Channel 0 is bit 0.
.SS PIO.0 ...  PIO.7 PIO.ALL PIO.BYTE
.I read-write, yes-no
.br
State of the open-drain output (
.I PIO
) pin. 0 = non-conducting (off), 1 = conducting (on).
.br
Writing zero will turn off the switch, non-zero will turn on the switch. Reading the
.I PIO
state will return the switch setting. To determine the actual logic level at the switch, refer to the
.I sensed.0 ... sensed.7 sensed.ALL sensed.BYTE
property.
.br
.I ALL
references all channels simultaneously, comma separated.
.br
.I BYTE
references all channels simultaneously as a single byte. Channel 0 is bit 0.
.SS power
.I read-only, yes-no
.br
Is the
.I DS2408
powered parasitically (0) or separately on the Vcc pin (1)?
.SS sensed.0 ... sensed.7 sensed.ALL
.I read-only, yes-no
.br
Logic level at the
.I PIO
pin. 0 = ground. 1 = high (~2.4V - 5V ). Really makes sense only if the
.I PIO
state is set to zero (off), else will read zero.
.br
.I ALL
references all channels simultaneously, comma separated.
.br
.I BYTE
references all channels simultaneously as a single byte. Channel 0 is bit 0.
.SS strobe
.I read-write, yes-no
.br
RSTZ Pin Mode Control. Configures RSTZ as either RST input or STRB output:
.TP
.I 0
configured as RST input (default)
.TP
.I 1
configured as STRB output
.PP
.SS por
.I read-write, yes-no
.br
Specifies whether the device has performed power-on reset. This bit can only
be cleared to 0 under software control. As long as this bit is 1 the device
will always respond to a conditional search.
.SS out_of_testmode
.I write-only, yes-no
.br
Write "1" to this property to make sure the device has been properly initialized on startup.
.PP
The datasheet says that under some conditions the startup (power-up) will leave the device in the "testmode" state. Any problems with "Channel Access Write" will trigger this property automaticlly, but this property makes explicit initialization possible as well.
.SS set_alarm
.I read-write, integer unsigned (0-333333333)
.br
A number consisting of 9 digits XYYYYYYYY, where:
.TP
X
select source and logical term 
.br 
.I 0
PIO   OR 
.br 
.I 1
latch OR 
.br 
.I 2
PIO   AND 
.br 
.I 3
latch AND
.TP
Y
select channel and polarity
.br 
.I 0
Unselected (LOW) 
.br
.I 1
Unselected (HIGH) 
.br
.I 2
Selected    LOW 
.br
.I 3
Selected    HIGH
.PP
All digits will be truncated to the 0-3 range. Leading zeroes are optional. Low-order digit is channel 0.
.PP
Example:
.TP
100000033
Responds on Conditional Search when latch.1 or latch.0 are set to 1.
.TP
222000000
Responds on Conditional Search when sensed.7 and sensed.6 are set to 0.
.TP
000000000 (0)
Never responds to Conditional Search.
.SH LCD_H LCD SCREEN PROPERITES
This mode uses the 
.I DS2408
attached to a Hitachi HD44780 LCD controller in 4-bit mode. See 
.I DATASHEET
for published details. Based on a commercial product from
.I HobbyBoards
by Erik Vickery.
.SS LCD_H/clear
.I write-only, yes-no
.br
This will
.I clear
the screen and place the cursor at the start.
.SS LCD_H/home
.I write-only, yes-no
.br
Positions the cursor in the
.I home
(upper left) position, but leaves the current text intact.
.SS LCD_H/screen
.I write-only, ascii text
.br
Writes to the LCD 
.I screen
at the current position.
.SS LCD_H/screenyc
.I write-only, ascii text
.br
Writes to an LCD screen at a specified location. The controller doesn't know the true LCD dimensions, but typical selections are:
2x16 2x20 4x16 and 4x20.
.TP
Y (row)
range 1 to 2 (or 4)
.TP
X (column)
range 1 to 16 (or 20)
.P
There are two formats allowed for the
.I screenyx
text, either ascii (readable text) or a binary form.
.TP 
2 binary bytes
The two first characters of the passed string have the line and row: 
e.g. "\\x02\\x04string" perl string writes "string" at line 2 column 4.
.TP 
ascii 2,12:
Two numbers giving line and row:  Separate with a comma and end with a colon
e.g. "2,4:string" writes "string" at line 2 column 4.
.TP 
ascii 12:
Single column number on the (default) first line:  End with a colon
e.g. "12:string" writes "string" at line 1 column 12.
.P
The positions are 1-based (i.e. the first position is 1,1).
.SS LCD_H/onoff
.I write-only, unsigned
.br
Sets several screen display functions. The selected choices should be added together.
.TP
4
Display on
.TP
2
Cursor on
.TP
1
Cursor blinking
.SS LCD_H/message
.I write-only, ascii text
.br
Writes a
.I message
to the LCD screen after clearing the screen first.
This is the easiest way to display a message.
.SS LCD_H/redefchar.0-7|ALL
.I write-only, binary
.br
Redefines one of 8 user-designed character glyphs for the LCD screen (5x8 pixels).
.PP
Each byte defines a horizontal line top to bottom. All 5 pixels corresponds to 0x1F and a blank line is 0x00.
.PP
Format is 8 binary bytes.
.SS LCD_H/redefchar_hex.0-7|ALL
.I write-only, ascii
.br
Redefines one of 8 user-designed character glyphs for the LCD screen (5x8 pixels).
.PP
Each byte defines a horizontal line top to bottom. All 5 pixels corresponds to 0x1F and a blank line is 0x00.
.PP
Format is 8 hexidecomal bytes (16 characters).
.SH LCD_M LCD SCREEN PROPERITES
This mode uses the 
.I DS2408
attached to a Hitachi HD44780 LCD controller in 8-bit mode. See 
.I DATASHEET
for published details. Based on a design from Maxim and a commercial product from
.I AAG.
.SS LCD_M/clear
.I write-only, yes-no
.br
This will
.I clear
the screen and place the cursor at the start.
.SS LCD_M/home
.I write-only, yes-no
.br
Positions the cursor in the
.I home
(upper left) position, but leaves the current text intact.
.SS LCD_M/screen
.I write-only, ascii text
.br
Writes to the LCD 
.I screen
at the current position.
.SS LCD_M/screenyc
.I write-only, ascii text
.br
Writes to an LCD screen at a specified location. The controller doesn't know the true LCD dimensions, but typical selections are:
2x16 2x20 4x16 and 4x20.
.TP
Y (row)
range 1 to 2 (or 4)
.TP
X (column)
range 1 to 16 (or 20)
.P
There are two formats allowed for the
.I screenyx
text, either ascii (readable text) or a binary form.
.TP 
2 binary bytes
The two first characters of the passed string have the line and row: 
e.g. "\\x02\\x04string" perl string writes "string" at line 2 column 4.
.TP 
ascii 2,12:
Two numbers giving line and row:  Separate with a comma and end with a colon
e.g. "2,4:string" writes "string" at line 2 column 4.
.TP 
ascii 12:
Single column number on the (default) first line:  End with a colon
e.g. "12:string" writes "string" at line 1 column 12.
.P
The positions are 1-based (i.e. the first position is 1,1).
.SS LCD_M/onoff
.I write-only, unsigned
.br
Sets several screen display functions. The selected choices should be added together.
.TP
4
Display on
.TP
2
Cursor on
.TP
1
Cursor blinking
.SS LCD_M/message
.I write-only, ascii text
.br
Writes a
.I message
to the LCD screen after clearing the screen first.
This is the easiest way to display a message.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
Use the
.I set_alarm
property to set the alarm triggering criteria.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2408
The
.B DS2408 (3)
allows control of other devices, like LEDs and relays. It extends the
.B DS2406
to 8 channels and includes memory.
.br
Alternative switches include the
.B DS2406, DS2407
and even
.B DS2450
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2408.pdf
.br
http://www.hobby-boards.com/catalog/howto_lcd_driver.php
.br
http://www.maxim-ic.com/appnotes.cfm/appnote_number/3286
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
