###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-033.nasl 3503 2009-07-15 09:14:35Z jul $
#
# Microsoft Virtual PC/Server Privilege Escalation Vulnerability (969856)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900690);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1542");
  script_bugtraq_id(35601);
  script_name("Microsoft Virtual PC/Server Privilege Escalation Vulnerability (969856)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-033.

  Vulnerability Insight:
  The flaw is caused due to the application not properly validating required
  CPU privilege levels of certain machine instructions running within the guest
  operating system environment.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code with
  escalated privileges on the guest operating system.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Virtual PC 2004 Service Pack 1 and prior
  Microsoft Virtual PC 2007 Service Pack 1 and prior
  Microsoft Virtual Server 2005 R2 Service Pack 1 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-033.mspx

  References:
  http://secunia.com/advisories/35808
  http://www.vupen.com/english/advisories/2009/1890
  ghhttp://www.microsoft.com/technet/security/bulletin/ms09-033.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the vulnerable SYS File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(registry_key_exists(key:"SOFTWARE\Microsoft\Virtual PC"))
{
  pcPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                           item:"Install Path");
  if(!pcPath){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:pcPath);
  pcfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                        string:pcPath + "\drivers\VMM.sys");

  pcVer = GetVer(file:pcfile, share:share);
  if(pcVer != NULL)
  {
    # Grep for VMM.sys version 1.1.400.0 < 1.1.465.15 for Virtual PC 2004 SP1
    if(version_in_range(version:pcVer, test_version:"1.1.400.0",
                                       test_version2:"1.1.465.14")){
      security_hole(0);
    }
    # Grep for VMM.sys version 1.1.500.0 < 1.1.598.0 for Virtual PC 2007
    else if(version_in_range(version:pcVer, test_version:"1.1.500.0",
                                            test_version2:"1.1.597.0")){
      security_hole(0);
    }
    # Grep for VMM.sys version 1.1.600.0 < 1.1.656.0 for Virtual PC 2007 SP1
    else if(version_in_range(version:pcVer, test_version:"1.1.600.0",
                                            test_version2:"1.1.655.0")){
      security_hole(0);
    }
    exit(0);
  }
}

if(registry_key_exists(key:"SOFTWARE\Microsoft\Virtual Server"))
{
  srvPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(!srvPath){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:srvPath);
  srvfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                         string:srvPath + "\drivers\VMM.sys");

  srvVer = GetVer(file:srvfile, share:share);
  if(srvVer != NULL)
  {
    # Check for Virtual Server 2005 R2 Service Pack 1 version < 1.1.656.0
    if(version_is_less(version:srvVer, test_version:"1.1.655.0")){
      security_hole(0);
    }
  }
}
