##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_mult_vuln_feb09_lin.nasl 1034 2009-02-17 19:00:29Z feb $
#
# Wireshark Multiple Vulnerabilities Feb 09 (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800246);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_bugtraq_id(33690);
  script_cve_id("CVE-2009-0599", "CVE-2009-0600", "CVE-2009-0601");
  script_name("Wireshark Multiple Vulnerabilities Feb 09 (Linux)");
  desc = "

  Overview: This host is installed with Wireshark and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to,
  - a boundary error in the processing of NetScreen Snoop capture files.
  - format string vulnerability in wireshark through format string specifiers
    in the HOME environment variable.
  - improper handling of Tektronix K12 text capture files as demonstrated by a
    file with exactly one frame.

  Impact:
  Successful exploitation will let the attacker cause denial of service to the
  application by crafting malicious packets.

  Affected Software/OS:
  Wireshark for Linux version 0.99.6 through 1.0.5

  Fix: Upgrade to the latest version 1.0.6
  http://www.wireshark.org/download.html

  References:
  http://secunia.com/advisories/33872
  http://www.wireshark.org/security/wnpa-sec-2009-01.html
  https://bugs.wireshark.org/bugzilla/attachment.cgi?id=2590

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

wireshark = get_kb_item("Wireshark/Linux/Ver");
if(!wireshark){
  exit(0);
}

# Grep for Wireshark version prior to 1.0.6
if(version_in_range(version:wireshark, test_version:"0.99.6",
                    test_version2:"1.0.5")){
  security_warning(0);
}
