###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for nagios vulnerability USN-698-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840225);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "698-1");
  script_cve_id("CVE-2008-5027");
  script_name( "Ubuntu Update for nagios vulnerability USN-698-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Nagios did not properly parse commands submitted using
  the web interface. An authenticated user could use a custom form or a browser
  addon to bypass security restrictions and submit unauthorized commands.

  Affected Software/OS:
  nagios vulnerability on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000813.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nagios vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"nagios-mysql", ver:"1.3-cvs.20050402-8ubuntu8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios-pgsql", ver:"1.3-cvs.20050402-8ubuntu8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios-text", ver:"1.3-cvs.20050402-8ubuntu8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios-common", ver:"1.3-cvs.20050402-8ubuntu8", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}