###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_squid_dos_vuln_feb10.nasl 7104 2010-02-04 12:45:380Z feb $
#
# Squid 'lib/rfc1035.c' Denial Of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Updataed By:
# Antu Sanadi <santu@secpod.com> on 2010-02-16
# included the port check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800460);
  script_version("$Revision: 7664 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0308");
  script_name("Squid 'lib/rfc1035.c' Denial Of Service Vulnerability");
  desc = "
  Overview: This host is running Squid and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'lib/rfc1035.c' when, processing crafted DNS
  packet that only contains a header.

  Impact:
  Successful exploitation could allow remote attackers to cause a denial of service
  via a crafted auth header.

  Affected Software/OS:
  Squid Version 2.x, 3.0 to 3.0.STABLE22, and  3.1 to 3.1.0.15

  Fix:  Apply patches or upgrade to the squid version 3.0.STABLE23 or 3.1.0.16
  http://www.squid-cache.org/Download/
  http://www.squid-cache.org/Versions/v2/HEAD/changesets/12597.patch
  http://www.squid-cache.org/Versions/v3/3.0/changesets/squid-3.0-9163.patch
  http://www.squid-cache.org/Versions/v3/3.1/changesets/squid-3.1-9853.patch

  *****
  NOTE : Ignore this warning, if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/38455
  http://secunia.com/advisories/38451
  http://xforce.iss.net/xforce/xfdb/56001
  http://www.vupen.com/english/advisories/2010/0260
  http://www.squid-cache.org/Advisories/SQUID-2010_1.txt

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.7
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Squid");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_squid_detect.nasl");
  exit(0);
}


include("version_func.inc");

port = 3128;
if(!get_port_state(port)){
  port = 8080;
}

squidVer = get_kb_item(string("www/", port, "/Squid"));
if(isnull(squidVer)){
  exit(0);
}

if((squidVer =~ "^2\.0") ||
    version_in_range(version:squidVer, test_version:"3.1", test_version2:"3.1.0.15") ||
    version_in_range(version:squidVer, test_version:"3.0", test_version2:"3.0.STABLE22")){
  security_warning(port);
}
