###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for cobbler FEDORA-2008-10000
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860747);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-10000");
  script_name( "Fedora Update for cobbler FEDORA-2008-10000");
  desc = "

  Vulnerability Insight:
  Cobbler is a network boot and update server.  Cobbler
  supports PXE, provisioning virtualized images, and
  reinstalling existing Linux machines.  The last two
  modes require a helper tool called 'koan' that
  integrates with cobbler.  Cobbler's advanced features
  include importing distributions from DVDs and rsync
  mirrors, kickstart templating, integrated yum
  mirroring, and built-in DHCP/DNS Management.  Cobbler has
  a Python and XMLRPC API for integration with other
  applications.


  Affected Software/OS:
  cobbler on Fedora 10

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-November/msg00789.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of cobbler");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC10")
{

  if(isrpmvuln(pkg:"cobbler", rpm:"cobbler~1.2.9~1.fc10", rls:"FC10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}