# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6760 (deluge)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64304);
 script_cve_id("CVE-2009-1760");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-6760 (deluge)";
 script_name(name);

 desc = "The remote host is missing an update to deluge
announced via advisory FEDORA-2009-6760.

Update Information:

Deluge 1.1.9 contains updated translations and fixes for a move torrent issue
(now only happens when the torrent has data downloaded), a folder renaming bug
(renaming a parent folder into multiple folders), and an issue with adding a
remote torrent in the WebUI.    This update also includes all upstream bug-fixes
and enhancements in versions 1.1.7 and 1.1.8 (which were skipped in this
package). For a full list of these changes, please see the upstream changelog:
http://dev.deluge-torrent.org/wiki/ChangeLog    In addition, the included copy
of rb_libtorrent has been updated to fix a potential directory traversal
vulnerability which would allow a remote attacker to create or overwrite
arbitrary files via a .. (dot dot) and partial relative pathname in a
specially-crafted torrent.

ChangeLog:

* Wed Jun 17 2009 Peter Gordon  - 1.1.9-1
- Update to new upstream bug-fix release (1.1.9), updates internal libtorrent
copy to fix CVE-2009-1760 (#505523).
- Adds dependency on chardet for fixing lots of bugs with torrents
which are not encoded as UTF-8.
- Add back the flags, in an optional -flags subpackage as per the new Flags
policy (Package_Maintainers_Flags_Policy on the wiki).
- Add LICENSE and README to installed documentation.

References:

[ 1 ] Bug #505523 - CVE-2009-1760 rb_libtorrent: arbitrary file overwrite vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=505523

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update deluge' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6760

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6760 (deluge)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"deluge", rpm:"deluge~1.1.9~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"deluge-flags", rpm:"deluge-flags~1.1.9~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"deluge-debuginfo", rpm:"deluge-debuginfo~1.1.9~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
