# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-13592 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66578);
 script_cve_id("CVE-2009-4376", "CVE-2009-4377");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 12 FEDORA-2009-13592 (wireshark)");

 desc = "The remote host is missing an update to wireshark
announced via advisory FEDORA-2009-13592.

For details, please visit the referenced advisories.

ChangeLog:

* Fri Dec 18 2009 Patrick Monnerat  1.2.5-3
- Autoconf macro for plugin development.
* Fri Dec 18 2009 Radek Vokal  - 1.2.5-2
- upgrade to 1.2.5
- fixes security vulnaribilities, see http://www.wireshark.org/security/wnpa-sec-2009-09.html
- split -devel package (#547899, #203642, #218451)
- removing root warning dialog (#543709)
- enable lua support - http://wiki.wireshark.org/Lua
- attempt to fix filter crash on 64bits

References:

[ 1 ] Bug #549578 - CVE-2009-4377 wireshark: invalid pointer dereference in SMB/SMB2 dissectors
https://bugzilla.redhat.com/show_bug.cgi?id=549578

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wireshark' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-13592

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-13592 (wireshark)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.2.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-devel", rpm:"wireshark-devel~1.2.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.2.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.2.5~3.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
