# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1882-1 (xapian-omega)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64865);
 script_cve_id("CVE-2009-2947");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1882-1 (xapian-omega)");

 desc = "The remote host is missing an update to xapian-omega
announced via advisory DSA 1882-1.

It was discovered that xapian-omega, a CGI interface for searching xapian
databases, is not properly escaping user supplied input when printing
exceptions.  An attacker can use this to conduct cross-site scripting
attacks via crafted search queries resulting in an exception and steal
potentially sensitive data from web applications running on the same domain
or embedding the search engine into a website.

For the oldstable distribution (etch), this problem has been fixed in
version 0.9.9-1+etch1.

For the stable distribution (lenny), this problem has been fixed in
version 1.0.7-3+lenny1.

For the testing (squeeze) and unstable (sid) distribution, this problem
will be fixed soon.


We recommend that you upgrade your xapian-omega packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201882-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1882-1 (xapian-omega)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xapian-omega", ver:"0.9.9-1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xapian-omega", ver:"1.0.7-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
