# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1342-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58513);
 script_cve_id("CVE-2007-2926");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1342-2 (bind9)";
 script_name(name);

 desc = "The remote host is missing an update to bind9
announced via advisory DSA 1342-2.

This update provides fixed packages for the oldstable distribution (sarge).
For reference the original advisory text:

Amit Klein discovered that the BIND name server generates predictable
DNS query IDs, which may lead to cache poisoning attacks.

For the oldstable distribution (sarge) this problem has been fixed in
version 9.2.4-1sarge3. An update for mips, powerpc and hppa is not yet
available, they will be released soon.

For the stable distribution (etch) this problem has been fixed in
version 9.3.4-2etch1. An update for mips is not yet available, it will
be released soon.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your BIND packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201342-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1342-2 (bind9)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bind9-doc", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9-host", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnsutils", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind-dev", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdns16", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisc7", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccc0", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccfg0", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblwres1", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lwresd", ver:"9.2.4-1sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9-doc", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9-host", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnsutils", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind-dev", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind9-0", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdns22", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisc11", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccc0", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccfg1", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblwres9", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lwresd", ver:"9.3.4-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
