SET(FFTW3_FOUND "NO")

SET(FFTW3_PREFIX "/usr/local/fftw3/" CACHE STRING
	"libftdi is installed in this prefix (if non-standard)")

SET(FFTW3_SEARCH_PATHS
	${FFTW3_PREFIX}/
	/sw/
	/usr/
	/usr/local/
	C:/msys/1.0/local
)

FIND_PATH(FFTW3_INCLUDE_DIR
	NAMES fftw3.h
	PATH_SUFFIXES /include/ .
	PATHS ${FFTW3_SEARCH_PATHS}
)

FIND_LIBRARY(FFTW3_LIBRARY
	NAMES fftw3
	PATH_SUFFIXES /lib/ .
	PATHS ${FFTW3_SEARCH_PATHS}
)


IF(FFTW3_LIBRARY AND FFTW3_INCLUDE_DIR)
  SET(FFTW3_FOUND "YES")
ENDIF(FFTW3_LIBRARY AND FFTW3_INCLUDE_DIR)

IF(FFTW3_FOUND)
  IF(NOT FFTW3_FIND_QUIETLY)
    MESSAGE(STATUS "Found FFTW3: ${FFTW3_LIBRARY}")
  ENDIF(NOT FFTW3_FIND_QUIETLY)
ELSE(FFTW3_FOUND)
  IF(FFTW3_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find FFTW3 Library")
  ENDIF(FFTW3_FIND_REQUIRED)
ENDIF(FFTW3_FOUND)

