/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.bzip2.BZip2DummyCompressor;
import org.apache.hadoop.io.compress.bzip2.BZip2DummyDecompressor;
import org.apache.hadoop.io.compress.bzip2.CBZip2InputStream;
import org.apache.hadoop.io.compress.bzip2.CBZip2OutputStream;

public class BZip2Codec
implements CompressionCodec {
    private static final String HEADER = "BZ";
    private static final int HEADER_LEN = "BZ".length();

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new BZip2CompressionOutputStream(out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return this.createOutputStream(out);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return BZip2DummyCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        return new BZip2DummyCompressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new BZip2CompressionInputStream(in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return this.createInputStream(in);
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return BZip2DummyDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        return new BZip2DummyDecompressor();
    }

    @Override
    public String getDefaultExtension() {
        return ".bz2";
    }

    private static class BZip2CompressionInputStream
    extends CompressionInputStream {
        private CBZip2InputStream input;
        boolean needsReset = true;

        public BZip2CompressionInputStream(InputStream in) throws IOException {
            super(in);
        }

        private BufferedInputStream readStreamHeader() throws IOException {
            BufferedInputStream bufferedIn = null;
            if (this.in != null) {
                String header;
                bufferedIn = new BufferedInputStream(this.in);
                bufferedIn.mark(HEADER_LEN);
                byte[] headerBytes = new byte[HEADER_LEN];
                int actualRead = bufferedIn.read(headerBytes, 0, HEADER_LEN);
                if (actualRead != -1 && (header = new String(headerBytes)).compareTo(BZip2Codec.HEADER) != 0) {
                    bufferedIn.reset();
                }
            }
            if (bufferedIn == null) {
                throw new IOException("Failed to read bzip2 stream.");
            }
            return bufferedIn;
        }

        @Override
        public void close() throws IOException {
            if (!this.needsReset) {
                this.input.close();
                this.needsReset = true;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            return this.input.read(b, off, len);
        }

        private void internalReset() throws IOException {
            if (this.needsReset) {
                this.needsReset = false;
                BufferedInputStream bufferedIn = this.readStreamHeader();
                this.input = new CBZip2InputStream(bufferedIn);
            }
        }

        @Override
        public void resetState() throws IOException {
            this.needsReset = true;
        }

        @Override
        public int read() throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            return this.input.read();
        }
    }

    private static class BZip2CompressionOutputStream
    extends CompressionOutputStream {
        private CBZip2OutputStream output;
        private boolean needsReset = true;

        public BZip2CompressionOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        private void writeStreamHeader() throws IOException {
            if (this.out != null) {
                this.out.write(BZip2Codec.HEADER.getBytes());
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.finish();
            this.needsReset = true;
        }

        private void internalReset() throws IOException {
            if (this.needsReset) {
                this.needsReset = false;
                this.writeStreamHeader();
                this.output = new CBZip2OutputStream(this.out);
            }
        }

        @Override
        public void resetState() throws IOException {
            this.needsReset = true;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.flush();
            this.output.close();
            this.needsReset = true;
        }
    }
}

