structure Stable : STABLE =
  struct

    type checkpoint =(
        unit GCAbleGraph.Node.t option ref
       )

    open Thread (* getTid *)
    open Channel (* mergeChannel *)

    fun stableCP(f:'a -> 'b, comp: unit -> unit): ('a -> 'b) *  unit GCAbleGraph.Node.t option ref  = 
      let val nodeRef = ref NONE
          fun newFun(arg) =
            let val con = ref (fn () => ())
                val _ = MLton.Cont.callcc(fn z =>
                                   (con:= (fn () => 
                                             (MLton.Cont.throw(z, ()); ())
                                          ); ()
                                   )
                                 )
                val _ = StableGraph.schedThread(con, getTid())
                val _ = StableGraph.enterSS(getTid (), comp, nodeRef)
                val ret = f(arg)
                val _ = StableGraph.exitSS(getTid ())
            in ret
            end
      in (newFun, nodeRef)
      end

    fun stable(f) = 
      let val (f, _(*cp*)) = stableCP(f, fn()=>())
      in f
      end

    fun stabilize'(node) = 
      let val _ = MLton.Thread.atomicBegin()
          val (threads2Restore, threads2Kill) = 
            StableGraph.stabilizeGraph(Scheduler.getCurThreadId(), node)
          val _ = Scheduler.stabilizeQs(threads2Restore, threads2Kill)
          val _ = StableGraph.debug("API - finished stabalize\n")
          val _ = MLton.Thread.atomicEnd()
      in ()
      end

    fun stabilize() = (stabilize'(NONE); exit())
    fun stabilizeCP(cp) = 
      case !cp
        of NONE => ()
         | SOME cp => stabilize'(SOME(cp))

    fun rebindReferences(arg) =
      let val a = !arg
          val b = fn() => arg:=a
          val tid = getTid()
      in StableGraph.addReference(tid, b)
      end

    val unmonitoredAssign = (op :=)
    fun monitoredAssign(r: 'a ref, l: 'a) = (print("new assign\n");rebindReferences(r); r:=l)

end