/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef XResource_H
#include "XResource.h"
#endif

static map<string, XResource*>* resources = 0;


XResource::XResource(const string& r, const string& x)
{      
	if(resources == 0)
		resources = new map<string,XResource*>;
	
	name_  = r;
	motif_ = x;
		(*resources)[r] = this;
}

XResource::~XResource()
{
}

void XResource::setValues(Widget w, const Request& r)
{	
		              
   	if(!resources) return;

	for(map<string,XResource*>::iterator j = resources->begin(); j != resources->end(); ++j)
		if(r.countValues((*j).second->name_.c_str()))
			(*j).second->setValue(w,r);

}

void* XResourceTranslator(const string& name, const string& motif) {
       return   new  XBasicResource<int>(name, motif);
}

