
module Hex where
import Data.Char
import Data.Map hiding (map)
import Data.Maybe
 
nums :: [Int]
nums = [0 .. 15]
 
chars :: [Char]
chars = (['0' .. '9'] ++ ['A' .. 'F'])
 
fromm :: Map Int Char
fromm = fromList $ zip nums chars
 
tom :: Map Char Int
tom = fromList $ zip chars nums
 
hexChar :: Char -> String
hexChar c
  = concat
      (map
         (\ i ->
            fromMaybe ""
              ((Data.Map.lookup
                  ((if (i == 0) then (ord c) else (ord c) `div` (16 ^ i)) `mod`
                     (16 :: Int))
                  fromm)
                 >>= (\ x -> return [x])))
         (reverse [0 .. 7] :: [Int]))
 
hex :: String -> String
hex s = concat (map hexChar s)
 
unhex :: String -> String
unhex (a : (b : (c : (d : (e : (f : (g : (h : xs))))))))
  = (chr
       (sum
          (map
             (\ (i, cc) -> (16 ^ i) * (fromMaybe 0 (Data.Map.lookup cc tom)))
             (zip (reverse [0 .. 7] :: [Int]) [a, b, c, d, e, f, g, h]))))
      : (unhex xs)
unhex _ = []
