# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.typed_array__ih_e import TypedArray_IhE


class SparseArray_IhE(TypedArray_IhE):
    r"""
    SparseArray<unsigned char> - Sparse, independent coordinate
    storage for N-way arrays.
    
    Superclass: TypedArray[uint8]
    
    SparseArray is a concrete Array implementation that stores
    values using sparse independent coordinate storage.  This means that
    the array stores the complete set of coordinates and the value for
    each non-null value in the array. While this approach requires
    slightly more storage than other sparse storage schemes (such as
    Compressed-Row or Compressed-Column), it is easier and more efficient
    to work with when implementing algorithms, and it generalizes well
    for arbitrary numbers of dimensions.
    
    In addition to the value retrieval and update methods provided by
    TypedArray, SparseArray provides methods to:
    
    Get and set a special 'null' value that will be returned when
    retrieving values for undefined coordinates.
    
    Clear the contents of the array so that every set of coordinates is
    undefined.
    
    Sort the array contents so that value coordinates can be visited in a
    specific order.
    
    Retrieve pointers to the value- and coordinate-storage memory blocks.
    
    Reserve storage for a specific number of non-null values, for
    efficiency when the number of non-null values is known in advance.
    
    Recompute the array extents so that they bound the largest set of
    non-nullptr values along each dimension.
    
    Specify arbitrary array extents.
    
    Add values to the array in amortized-constant time.
    
    Validate that the array does not contain duplicate coordinates.
    
    @sa
    Array, TypedArray, DenseArray
    
    @par Thanks: Developed by Timothy M. Shead (tshead@sandia.gov) at
    Sandia National Laboratories.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSparseArray_IhE, obj, update, **traits)
    
    null_value = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the value that will be returned by get_value() for nullptr
        areas of the array.
        """
    )

    def _null_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNullValue,
                        self.null_value)

    def get_value(self, *args):
        """
        get_value(self, i:int) -> int
        get_value(self, i:int, j:int) -> int
        C++: const unsigned char &get_value(CoordinateT i, CoordinateT j)
            override;
        get_value(self, i:int, j:int, k:int) -> int
        C++: const unsigned char &get_value(CoordinateT i, CoordinateT j,
            CoordinateT k) override;
        get_value(self, coordinates:ArrayCoordinates) -> int
        C++: const unsigned char &get_value(
            const ArrayCoordinates &coordinates) override;
        Returns the value stored in the array at the given coordinates.
        Note that the number of dimensions in the supplied coordinates
        must match the number of dimensions in the array.
        """
        my_args = deref_array(args, [['int'], ('int', 'int'), ('int', 'int', 'int'), ['vtkArrayCoordinates']])
        ret = self._wrap_call(self._vtk_obj.GetValue, *my_args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, i:int, value:int) -> None
        C++: void set_value(CoordinateT i, const unsigned char &value)
            override;
        set_value(self, i:int, j:int, value:int) -> None
        C++: void set_value(CoordinateT i, CoordinateT j,
            const unsigned char &value) override;
        set_value(self, i:int, j:int, k:int, value:int) -> None
        C++: void set_value(CoordinateT i, CoordinateT j, CoordinateT k,
            const unsigned char &value) override;
        set_value(self, coordinates:ArrayCoordinates, value:int) -> None
        C++: void set_value(const ArrayCoordinates &coordinates,
            const unsigned char &value) override;
        Overwrites the value stored in the array at the given
        coordinates. Note that the number of dimensions in the supplied
        coordinates must match the number of dimensions in the array.
        """
        my_args = deref_array(args, [('int', 'int'), ('int', 'int', 'int'), ('int', 'int', 'int', 'int'), ('vtkArrayCoordinates', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetValue, *my_args)
        return ret

    def get_value_n(self, *args):
        """
        get_value_n(self, n:int) -> int
        
        Returns the n-th value stored in the array, where n is in the
        range [0, get_non_null_size()).  This is useful for efficiently
        visiting every value in the array.  Note that the order in which
        values are visited is undefined, but is guaranteed to match the
        order used by Array::GetCoordinatesN().
        """
        ret = self._wrap_call(self._vtk_obj.GetValueN, *args)
        return ret

    def set_value_n(self, *args):
        """
        set_value_n(self, n:int, value:int) -> None
        C++: void set_value_n(const SizeT n, const unsigned char &value)
            override;
        Overwrites the n-th value stored in the array, where n is in the
        range [0, get_non_null_size()).  This is useful for efficiently
        visiting every value in the array.  Note that the order in which
        values are visited is undefined, but is guaranteed to match the
        order used by Array::GetCoordinatesN().
        """
        ret = self._wrap_call(self._vtk_obj.SetValueN, *args)
        return ret

    def get_coordinate_storage(self, *args):
        """
        get_coordinate_storage(self, dimension:int) -> Pointer
        C++: CoordinateT *get_coordinate_storage(DimensionT dimension)
        Return a mutable reference to the underlying coordinate storage. 
        Coordinates for each dimension are stored contiguously as a
        one-dimensional array.  The ordering of coordinates within the
        array depends on the order in which values were added to the
        array, and any subsequent sorting.  Use at your own risk!
        """
        ret = self._wrap_call(self._vtk_obj.GetCoordinateStorage, *args)
        return ret

    def get_unique_coordinates(self, *args):
        """
        get_unique_coordinates(self, dimension:int) -> (int, ...)
        C++: std::vector<CoordinateT> get_unique_coordinates(
            DimensionT dimension)
        Returns the set of unique coordinates along the given dimension.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniqueCoordinates, *args)
        return ret

    def _get_value_storage(self):
        return self._vtk_obj.GetValueStorage()
    value_storage = traits.Property(_get_value_storage, desc=\
        r"""
        Return a mutable reference to the underlying value storage. 
        Values are stored contiguously, but in arbitrary order.  Use
        get_coordinate_storage() if you need to get the corresponding
        coordinates for a value.  Use at your own risk!
        """
    )

    def add_value(self, *args):
        """
        add_value(self, i:int, value:int) -> None
        C++: void add_value(CoordinateT i, const unsigned char &value)
        add_value(self, i:int, j:int, value:int) -> None
        C++: void add_value(CoordinateT i, CoordinateT j,
            const unsigned char &value)
        add_value(self, i:int, j:int, k:int, value:int) -> None
        C++: void add_value(CoordinateT i, CoordinateT j, CoordinateT k,
            const unsigned char &value)
        add_value(self, coordinates:ArrayCoordinates, value:int) -> None
        C++: void add_value(const ArrayCoordinates &coordinates,
            const unsigned char &value)
        Adds a new non-null element to the array.  Does not test to see
        if an element with matching coordinates already exists.  Useful
        for providing fast initialization of the array as long as the
        caller is prepared to guarantee that no duplicate coordinates are
        ever used.
        """
        my_args = deref_array(args, [('int', 'int'), ('int', 'int', 'int'), ('int', 'int', 'int', 'int'), ('vtkArrayCoordinates', 'int')])
        ret = self._wrap_call(self._vtk_obj.AddValue, *my_args)
        return ret

    def clear(self):
        """
        clear(self) -> None
        C++: void clear()
        Remove all non-null elements from the array, leaving the number
        of dimensions, the extent of each dimension, and the label for
        each dimension unchanged.
        """
        ret = self._vtk_obj.Clear()
        return ret
        

    def reserve_storage(self, *args):
        """
        reserve_storage(self, value_count:int) -> None
        C++: void reserve_storage(const SizeT value_count)
        Reserve storage for a specific number of values.  This is useful
        for reading external data using get_coordinate_storage() and
        get_value_storage(), when the total number of non-nullptr values in
        the array can be determined in advance.  Note that after calling
        reserve_storage(), all coordinates and values will be undefined,
        so you must ensure that every set of coordinates and values is
        overwritten.  It is the caller's responsibility to ensure that
        duplicate coordinates are not inserted into the array.
        """
        ret = self._wrap_call(self._vtk_obj.ReserveStorage, *args)
        return ret

    def set_extents_from_contents(self):
        """
        set_extents_from_contents(self) -> None
        C++: void set_extents_from_contents()
        Update the array extents to match its contents, so that the
        extent along each dimension matches the maximum index value along
        that dimension.
        """
        ret = self._vtk_obj.SetExtentsFromContents()
        return ret
        

    def sort(self, *args):
        """
        sort(self, sort:ArraySort) -> None
        C++: void sort(const ArraySort &sort)
        Sorts array values so that their coordinates appear in some
        well-defined order. The supplied ArraySort object controls
        which dimensions are sorted, and in what order, and should
        contain one-or-more sort dimensions, up to the number of
        dimensions stored in the array.
        """
        my_args = deref_array(args, [['vtkArray']])
        ret = self._wrap_call(self._vtk_obj.Sort, *my_args)
        return ret

    def validate(self):
        """
        validate(self) -> bool
        C++: bool validate()
        Validate the contents of the array, returning false if there are
        any problems. Potential problems include duplicate coordinates,
        which can be introduced into the array either through add_value()
        or direct access to coordinates storage; and coordinates
        out-of-bounds given the current array extents.
        
        * Note that Validate() is a heavyweight O(N log N) operation that
        is intended for
        * temporary use during debugging.
        """
        ret = self._vtk_obj.Validate()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('null_value', 'GetNullValue'), ('name',
    'GetName'), ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'name', 'null_value',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SparseArray_IhE, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SparseArray_IhE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['name', 'null_value', 'object_name']),
            title='Edit SparseArray_IhE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SparseArray_IhE properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

